/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.rio.file;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;
import wtf.g4s8.rio.file.WriteGreed;
import wtf.g4s8.rio.file.WriteRequest;

final class WriteTaskQueue
implements Runnable {
    private final CompletableFuture<Void> future;
    private final FileChannel channel;
    private final AtomicReference<Subscription> sub;
    private final Queue<WriteRequest> queue;
    private final WriteGreed greed;
    private final Executor exec;
    private final AtomicBoolean running = new AtomicBoolean();

    WriteTaskQueue(CompletableFuture<Void> future, FileChannel channel, AtomicReference<Subscription> sub, WriteGreed greed, Executor exec) {
        this.future = future;
        this.channel = channel;
        this.sub = sub;
        this.queue = new ConcurrentLinkedQueue<WriteRequest>();
        this.greed = greed;
        this.exec = exec;
    }

    @Override
    public void run() {
        while (!this.future.isDone()) {
            boolean empty;
            boolean requested = this.greed.request(this.sub.get());
            WriteRequest next = this.queue.poll();
            boolean bl = empty = next == null;
            if (!requested && empty) continue;
            if (empty) {
                this.running.set(false);
                next = this.queue.peek();
                boolean bl2 = empty = next == null;
                if (!empty && this.running.compareAndSet(false, true)) {
                    if (this.future.isDone()) break;
                    this.queue.remove(next);
                } else {
                    return;
                }
            }
            next.process(this.channel);
        }
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException err) {
                Logger.warn((Object)this, (String)"Failed to close channel: %[exception]s", (Object[])new Object[]{err});
            }
        }
        ((Subscription)this.sub.getAndSet(null)).cancel();
        this.running.set(false);
    }

    public void accept(WriteRequest req) {
        if (this.future.isDone()) {
            return;
        }
        if (req instanceof WriteRequest.Error) {
            this.queue.clear();
        }
        this.queue.add(req);
        if (this.running.compareAndSet(false, true)) {
            this.exec.execute(this);
        }
    }
}

