/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.tuples;

import wtf.g4s8.tuples.Pair;
import wtf.g4s8.tuples.TripletZip;
import wtf.g4s8.tuples.Tuple;

public interface Triplet<T, U, V> {
    public <R> R apply(Function<? super T, ? super U, ? super V, ? extends R> var1);

    default public void accept(Consumer<? super T, ? super U, ? super V> consumer) {
        this.apply((first, second, third) -> {
            consumer.accept(first, second, third);
            return Tuple.None.VALUE;
        });
    }

    default public Pair<T, U> pop() {
        return this.apply((first, second, third) -> Pair.of(first, second));
    }

    public static <T, U, V> Triplet<T, U, V> of(T first, U second, V third) {
        return new Tuple.TripletTuple<T, U, V>(first, second, third);
    }

    public static <T, U, V> Iterable<Triplet<T, U, V>> zip(Iterable<? extends T> first, Iterable<? extends U> second, Iterable<? extends V> third) {
        return new TripletZip<T, U, V>(first, second, third);
    }

    @FunctionalInterface
    public static interface Consumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }

    @FunctionalInterface
    public static interface Function<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

