/*
 * Decompiled with CFR 0.152.
 */
package wtf.g4s8.tuples;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import wtf.g4s8.tuples.Pair;
import wtf.g4s8.tuples.Triplet;
import wtf.g4s8.tuples.Unit;

abstract class Tuple<T, U, V>
implements Serializable {
    private static final long SerialVersionUID = 1974123789616905123L;
    private final T first;
    private final U second;
    private final V third;

    private Tuple(T first, U second, V third) {
        this.first = Objects.requireNonNull(first, "first is null");
        this.second = Objects.requireNonNull(second, "second is null");
        this.third = Objects.requireNonNull(third, "third is null");
    }

    public final <R> R apply(Function<? super T, ? extends R> func) {
        return func.apply(this.first);
    }

    public final void accept(Consumer<? super T> consumer) {
        consumer.accept(this.first);
    }

    public final <R> R apply(BiFunction<? super T, ? super U, ? extends R> func) {
        return func.apply(this.first, this.second);
    }

    public final void accept(BiConsumer<? super T, ? super U> consumer) {
        consumer.accept(this.first, this.second);
    }

    public final <R> R apply(Triplet.Function<? super T, ? super U, ? super V, ? extends R> func) {
        return func.apply(this.first, this.second, this.third);
    }

    public final void accept(Triplet.Consumer<? super T, ? super U, ? super V> consumer) {
        consumer.accept(this.first, this.second, this.third);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second) && Objects.equals(this.third, other.third);
    }

    public final int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public final String toString() {
        return String.format("<%s>", Stream.of(this.first, this.second, this.third).filter(x -> x != None.VALUE).map(Object::toString).collect(Collectors.joining(", ")));
    }

    static final class TripletTuple<T, U, V>
    extends Tuple<T, U, V>
    implements Triplet<T, U, V> {
        public TripletTuple(T first, U second, V third) {
            super(first, second, third);
        }

        @Override
        public Pair<T, U> pop() {
            return new PairTuple<Object, Object>(((Tuple)this).first, ((Tuple)this).second);
        }
    }

    static final class PairTuple<T, U>
    extends Tuple<T, U, None>
    implements Pair<T, U> {
        PairTuple(T first, U second) {
            super(first, second, (Object)None.VALUE);
        }

        @Override
        public <V> Triplet<T, U, V> push(V val) {
            return new TripletTuple<Object, Object, V>(((Tuple)this).first, ((Tuple)this).second, val);
        }

        @Override
        public Unit<T> pop() {
            return new UnitTuple<Object>(((Tuple)this).first);
        }
    }

    static final class UnitTuple<T>
    extends Tuple<T, None, None>
    implements Unit<T> {
        UnitTuple(T val) {
            super(val, (Object)None.VALUE, (Object)None.VALUE);
        }

        @Override
        public <U> Pair<T, U> push(U val) {
            return new PairTuple<Object, U>(((Tuple)this).first, val);
        }
    }

    static enum None {
        VALUE;

    }
}

