/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wurflapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.wurfl.wurflapi.CapabilityMatrix;
import net.sourceforge.wurfl.wurflapi.ObjectsManager;
import net.sourceforge.wurfl.wurflapi.Wurfl;
import net.sourceforge.wurfl.wurflapi.WurflDevice;
import nu.xom.Element;

public class ListManager {
    private Wurfl wu = null;
    private HashSet deviceIdSet = null;
    private ArrayList deviceIdSetSorted = null;
    private ArrayList capabilitySet = null;
    private HashMap listOfGroups = null;
    private HashMap deviceElementsListXOM = null;
    private HashMap deviceElementsList = null;
    private HashMap listOfUAWithDeviceID = null;
    private Map listOfListsOfCapabilityValuePairs = new HashMap(200, 0.75f);

    ListManager(Wurfl wurfl) {
        this.wu = wurfl;
        this.capabilitySet = this.wu.getListOfCapabilities();
        this.listOfGroups = this.wu.getListOfGroups();
        this.deviceIdSet = this.wu.getDeviceIdSet();
        this.deviceIdSetSorted = new ArrayList(this.deviceIdSet);
        Collections.sort(this.deviceIdSetSorted);
        this.listOfUAWithDeviceID = this.wu.getListOfUAWithDeviceID();
        this.deviceElementsListXOM = this.wu.getDeviceElementsList();
        Iterator iterator = this.deviceElementsListXOM.keySet().iterator();
        this.deviceElementsList = new HashMap(2053, 0.75f);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            WurflDevice wurflDevice = new WurflDevice((Element)this.deviceElementsListXOM.get(string));
            this.deviceElementsList.put(string, wurflDevice);
        }
    }

    public HashSet getDeviceIdSet() {
        return this.deviceIdSet;
    }

    public ArrayList getDeviceIdSetSorted() {
        return this.deviceIdSetSorted;
    }

    public ArrayList getCapabilitySet() {
        return this.capabilitySet;
    }

    public HashMap getListOfGroups() {
        return this.listOfGroups;
    }

    public HashMap getDeviceElementsList() {
        return this.deviceElementsList;
    }

    public HashMap getListOfUAWithDeviceID() {
        return this.listOfUAWithDeviceID;
    }

    public HashMap getCapabilitiesForDeviceID(String string) {
        Object v = this.listOfListsOfCapabilityValuePairs.get(string);
        if (v != null) {
            return (HashMap)v;
        }
        HashMap hashMap = new HashMap(this.capabilitySet.size());
        CapabilityMatrix capabilityMatrix = ObjectsManager.getCapabilityMatrixInstance();
        int n = 0;
        while (n < this.capabilitySet.size()) {
            hashMap.put(this.capabilitySet.get(n), capabilityMatrix.getCapabilityForDevice(string, (String)this.capabilitySet.get(n)));
            ++n;
        }
        this.listOfListsOfCapabilityValuePairs.put(string, hashMap);
        return hashMap;
    }
}

