/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wurflapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import net.sourceforge.wurfl.wurflapi.CapabilityMatrix;
import net.sourceforge.wurfl.wurflapi.ListManager;
import net.sourceforge.wurfl.wurflapi.UAManager;
import net.sourceforge.wurfl.wurflapi.Wurfl;
import net.sourceforge.wurfl.wurflapi.WurflException;

public class ObjectsManager {
    private static Object lock = new Object();
    private static Wurfl wurflInstance = null;
    private static CapabilityMatrix capabilityMatrixInstance = null;
    private static UAManager UAManagerInstance = null;
    private static ListManager ListManagerInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Wurfl getWurflInstance(String string, String string2) {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                wurflInstance = new Wurfl(string, string2);
            }
            return wurflInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Wurfl getWurflInstance(String string) {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                wurflInstance = new Wurfl(string);
            }
            return wurflInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Wurfl getWurflInstance() {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                String string = ObjectsManager.getWurflFileLocation();
                wurflInstance = new Wurfl(string);
            }
            return wurflInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wurflWebInit() {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                wurflInstance = new Wurfl("http://wurfl.sourceforge.net/wurfl.xml");
            }
        }
    }

    private static String getWurflFileLocation() {
        String string;
        Properties properties = new Properties();
        if (ObjectsManager.fileExists("wurfl.properties")) {
            System.out.println("wurfl.properties file found. Lemme have a look...");
            try {
                FileInputStream fileInputStream = new FileInputStream("wurfl.properties");
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("problems with wurfl.properties");
                iOException.printStackTrace();
                throw new WurflException("Problems with wurfl.properties");
            }
            string = properties.getProperty("wurflpath");
            if (string == null) {
                System.out.println("Expected wurflpath property not found in wurfl.properties file");
                string = "";
            }
            String string2 = string.indexOf("file://") != -1 ? string.substring(7, string.length()) : string;
            if (ObjectsManager.fileExists(string) || ObjectsManager.fileExists(string2)) {
                System.out.println("using " + string + " file found in wurfl.properties");
                return string;
            }
            System.out.println("file '" + string + "' (found in wurfl.properties)  does not exist");
        }
        System.out.println("Last try. Looking for wurfl.xml in temp directory");
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            string = "file:///C:/temp/wurfl.xml";
            if (ObjectsManager.fileExists("C:\\temp\\wurfl.xml")) {
                System.out.println(string + " found! I'll use this");
                return string;
            }
        } else {
            string = "file:///tmp/wurfl.xml";
            if (ObjectsManager.fileExists("/tmp/wurfl.xml")) {
                System.out.println(string + " found! I'll use this");
                return string;
            }
        }
        System.out.println("WURFL not found anywhere");
        System.out.println("You have 3 possibilities:");
        System.out.println("- define wurfl.properties in the same directory");
        System.out.println("  as your application and provide the wurfl.xml path");
        System.out.println("  ex: wurflpath = file://C:\\projects\\wurfl\\resources\\wurfl.xml");
        System.out.println("");
        System.out.println("- use ObjectsManager.wurflWebInit() to initialize");
        System.out.println("  with wurfl.xml latest version (requires internet connection)");
        System.out.println("");
        System.out.println("- place wurfl.xml in either C:\\temp (Windows) or /tmp (Unix)");
        System.out.println("");
        throw new WurflException("Cannot find WURFL file (wurfl.xml)");
    }

    private static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CapabilityMatrix getCapabilityMatrixInstance() {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                wurflInstance = new Wurfl(ObjectsManager.getWurflFileLocation());
            }
            if (capabilityMatrixInstance == null) {
                capabilityMatrixInstance = new CapabilityMatrix(wurflInstance);
            }
            return capabilityMatrixInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UAManager getUAManagerInstance() {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                wurflInstance = new Wurfl(ObjectsManager.getWurflFileLocation());
            }
            if (UAManagerInstance == null) {
                UAManagerInstance = new UAManager(wurflInstance);
            }
            return UAManagerInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ListManager getListManagerInstance() {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                wurflInstance = new Wurfl(ObjectsManager.getWurflFileLocation());
            }
            if (ListManagerInstance == null) {
                ListManagerInstance = new ListManager(wurflInstance);
            }
            return ListManagerInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWurflInitialized() {
        Object object = lock;
        synchronized (object) {
            return wurflInstance != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWURFLAsXML() {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                return "";
            }
            return wurflInstance.toXML();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initFromWebApplication(ServletContext servletContext) {
        Object object = lock;
        synchronized (object) {
            String string;
            File file;
            if (wurflInstance == null && (file = new File(string = servletContext.getRealPath("/WEB-INF/wurfl.xml"))).exists()) {
                wurflInstance = new Wurfl(file.toURI().toString());
                System.out.println("Initializing web-app with " + file.toURI().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initFromWebApplication(String string) {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                File file = new File(string);
                if (file.exists()) {
                    wurflInstance = new Wurfl(file.toURI().toString());
                    System.out.println("Initializing web-app with " + file.toURI().toString());
                } else {
                    System.out.println("WARNING: initialization failed. Could not find a WURFL file at " + string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initFromWebApplication(String string, String string2) {
        Object object = lock;
        synchronized (object) {
            if (wurflInstance == null) {
                File file = new File(string);
                if (file.exists()) {
                    File file2 = new File(string2);
                    if (file2.exists()) {
                        wurflInstance = new Wurfl(file.toURI().toString(), file2.toURI().toString());
                        System.out.println("Initializing web-app with " + file.toURI().toString() + " and " + file2.toURI().toString());
                    } else {
                        wurflInstance = new Wurfl(file.toURI().toString());
                        System.out.println("Initializing web-app with " + file.toURI().toString());
                        System.out.println("WARNING: patch file not found at " + file2.toURI().toString());
                    }
                } else {
                    System.out.println("WARNING: initialization failed. Could not find a WURFL file at " + string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetWurfl() {
        Object object = lock;
        synchronized (object) {
            wurflInstance = null;
            capabilityMatrixInstance = null;
            UAManagerInstance = null;
            ListManagerInstance = null;
            System.gc();
        }
    }
}

