/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wurflapi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.sourceforge.wurfl.wurflapi.WurflException;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;

class Wurfl {
    Document doc = null;
    private Elements devices = null;
    int numberOfDevices = 0;
    private HashSet deviceIdSet = null;
    private HashMap deviceElementsList = null;
    private HashMap listOfUAWithDeviceID = null;
    private HashMap listOfGroups = null;
    private ArrayList listOfCapabilities = new ArrayList(250);
    private HashSet setOfCapabilityNames = null;
    int numberOfCapabilities = 0;
    private HashMap genericCapabilityNameValues = new HashMap(250);
    private boolean patchfile_present = false;
    private boolean patchfile_found = false;
    private Element patch_root = null;

    Wurfl(String string, String string2) {
        try {
            Element element;
            Elements elements;
            Object object;
            Object object2;
            int n;
            Builder builder = new Builder();
            this.doc = builder.build(string);
            Element element2 = this.doc.getRootElement();
            Element element3 = element2.getFirstChildElement("devices");
            if (string2.equals("")) {
                System.out.println("trying to see if we can figure out the patch file");
                if (string.matches("(.*)wurfl\\.xml$")) {
                    n = string.indexOf("wurfl.xml");
                    object2 = string.substring(0, n);
                    string2 = (String)object2 + "wurfl_patch.xml";
                    System.out.println("potential patchfile: " + string2);
                }
            }
            if (!string2.equals("")) {
                try {
                    Builder builder2 = new Builder();
                    object2 = builder.build(string2);
                    this.patch_root = object2.getRootElement();
                    object = this.patch_root.getLocalName();
                    if (!((String)object).equals("wurfl_patch")) {
                        throw new WurflException("patch file must have <wurfl_patch> as root tag");
                    }
                    System.out.println("patch file " + string2 + " found!");
                    this.patchfile_found = true;
                }
                catch (Exception exception) {
                    System.out.println("patch file " + string2 + " not found or not good.");
                    System.out.println(exception.getMessage());
                }
            }
            if (this.patchfile_found) {
                try {
                    Element element4;
                    int n2;
                    Object object3;
                    Elements elements2;
                    Object object4;
                    Object object5;
                    Object object6;
                    ArrayList<String> arrayList = new ArrayList<String>(250);
                    object2 = new HashMap(250);
                    object = null;
                    int n3 = 0;
                    elements = element3.getChildElements("device");
                    int n4 = elements.size();
                    HashSet<Element> hashSet = new HashSet<Element>(n4);
                    element = new HashMap(2053, 0.75f);
                    HashMap<Object, Element> hashMap = new HashMap<Object, Element>(2053, 0.75f);
                    int n5 = 0;
                    while (n5 < n4) {
                        object6 = elements.get(n5).getAttributeValue("id");
                        object5 = elements.get(n5).getAttributeValue("fall_back");
                        object4 = elements.get(n5).getAttributeValue("user_agent");
                        element.put(object6, elements.get(n5));
                        hashSet.add((Element)object6);
                        hashMap.put(object4, (Element)object6);
                        ++n5;
                    }
                    object6 = (Element)element.get("generic");
                    object5 = object6.getChildElements("group");
                    object4 = new HashMap(object5.size(), 1.0f);
                    int n6 = 0;
                    while (n6 < object5.size()) {
                        elements2 = object5.get(n6).getChildElements("capability");
                        object3 = new ArrayList(elements2.size());
                        n3 += elements2.size();
                        n2 = 0;
                        while (n2 < elements2.size()) {
                            element4 = elements2.get(n2);
                            arrayList.add(element4.getAttributeValue("name"));
                            ((ArrayList)object3).add(element4.getAttributeValue("name"));
                            ((HashMap)object2).put(element4.getAttributeValue("name"), element4.getAttributeValue("value"));
                            ++n2;
                        }
                        ((HashMap)object4).put(object5.get(n6).getAttributeValue("id"), object3);
                        ++n6;
                    }
                    object = new HashSet(this.listOfCapabilities);
                    elements2 = this.patch_root.getFirstChildElement("devices");
                    if (elements2 == null) {
                        object3 = "Illegal syntax patch file: <devices> tag is missing!";
                        this.patch_parse_error((String)object3);
                    }
                    object3 = elements2.getChildElements("device");
                    n2 = 0;
                    while (n2 < object3.size()) {
                        Object object7;
                        String string3;
                        element4 = object3.get(n2);
                        String string4 = element4.getAttributeValue("id");
                        Element element5 = (Element)element.get(string4);
                        String string5 = element4.getAttributeValue("fall_back");
                        if (string5 == null || string5.equals("")) {
                            string3 = "device " + string4 + " in patch file does not have" + " a valid fallback value";
                            this.patch_parse_error(string3);
                        }
                        if ((string3 = element4.getAttributeValue("user_agent")) == null || string3.equals("") && !string4.equals("generic")) {
                            object7 = "device " + string4 + " in patch file does not have" + " a valid user_agent string";
                            this.patch_parse_error((String)object7);
                        }
                        if (hashSet.contains(string4)) {
                            Object object8;
                            if (!string4.equals("generic")) {
                                object7 = element5.getAttributeValue("fall_back");
                                if (!string5.equals(object7)) {
                                    object8 = new Attribute("fall_back", (String)object7);
                                    element5.addAttribute((Attribute)object8);
                                }
                                if (!string3.equals(object8 = element5.getAttributeValue("user_agent"))) {
                                    String string6 = "device " + string4 + ". Sorry. Patch file devices are not allowed" + " to override user-agent. If you need to do that, please define a new device" + " in the patch file.";
                                    this.patch_parse_error(string6);
                                }
                            }
                            object7 = element5.getChildElements("group");
                            object8 = new ArrayList(object7.size());
                            int n7 = 0;
                            while (n7 < object7.size()) {
                                ((ArrayList)object8).add(object7.get(n7).getAttributeValue("id"));
                                ++n7;
                            }
                            Elements elements3 = element4.getChildElements("group");
                            int n8 = 0;
                            while (n8 < elements3.size()) {
                                Object object9;
                                Element element6 = elements3.get(n8);
                                String string7 = element6.getAttributeValue("id");
                                if (string7 == null || string7.equals("")) {
                                    object9 = "patch file, device " + string4 + ": group without ID";
                                    this.patch_parse_error((String)object9);
                                }
                                if (!((ArrayList)object8).contains(string7)) {
                                    object9 = element6.copy();
                                    element5.appendChild(object9);
                                } else {
                                    object9 = null;
                                    int n9 = 0;
                                    while (n9 < object7.size()) {
                                        if (object7.get(n9).getAttributeValue("id").equals(string7)) {
                                            object9 = object7.get(n9);
                                        }
                                        ++n9;
                                    }
                                    this.merge_group_capabilities((Element)object9, element6);
                                }
                                ++n8;
                            }
                        } else {
                            object7 = (Element)element4.copy();
                            element3.appendChild((Node)object7);
                        }
                        ++n2;
                    }
                }
                catch (WurflException wurflException) {
                    System.out.println("There were problems with the patch file...discarding patch info.");
                    System.out.println("Re-initializing with " + string + ".");
                    this.doc = builder.build(string);
                    element2 = this.doc.getRootElement();
                    element3 = element2.getFirstChildElement("devices");
                }
            }
            this.devices = element3.getChildElements("device");
            this.numberOfDevices = this.devices.size();
            this.deviceIdSet = new HashSet(this.numberOfDevices);
            this.deviceElementsList = new HashMap(2053, 0.75f);
            this.listOfUAWithDeviceID = new HashMap(2053, 0.75f);
            n = 0;
            while (n < this.numberOfDevices) {
                object2 = this.devices.get(n).getAttributeValue("id");
                object = this.devices.get(n).getAttributeValue("fall_back");
                String string8 = this.devices.get(n).getAttributeValue("user_agent");
                this.deviceElementsList.put(object2, this.devices.get(n));
                this.deviceIdSet.add(object2);
                this.listOfUAWithDeviceID.put(string8, object2);
                ++n;
            }
            object2 = (Element)this.deviceElementsList.get("generic");
            object = object2.getChildElements("group");
            this.listOfGroups = new HashMap(object.size(), 1.0f);
            int n10 = 0;
            while (n10 < object.size()) {
                elements = object.get(n10).getChildElements("capability");
                ArrayList<String> arrayList = new ArrayList<String>(elements.size());
                this.numberOfCapabilities += elements.size();
                int n11 = 0;
                while (n11 < elements.size()) {
                    element = elements.get(n11);
                    this.listOfCapabilities.add(element.getAttributeValue("name"));
                    arrayList.add(element.getAttributeValue("name"));
                    this.genericCapabilityNameValues.put(element.getAttributeValue("name"), element.getAttributeValue("value"));
                    ++n11;
                }
                this.listOfGroups.put(object.get(n10).getAttributeValue("id"), arrayList);
                ++n10;
            }
            this.setOfCapabilityNames = new HashSet(this.listOfCapabilities);
        }
        catch (ValidityException validityException) {
            System.err.println("WURFL is not valid");
            validityException.printStackTrace();
            throw new WurflException("WURFL is not valid");
        }
        catch (ParsingException parsingException) {
            System.err.println("cannot parse the wurfl");
            parsingException.printStackTrace();
            throw new WurflException("cannot parse WURFL");
        }
        catch (IOException iOException) {
            System.err.println("problems reading " + string);
            iOException.printStackTrace();
            throw new WurflException("problems reading " + string);
        }
    }

    Wurfl(String string) {
        this(string, "");
    }

    boolean isDeviceIn(String string) {
        return this.deviceIdSet.contains(string);
    }

    boolean isCapabilityIn(String string) {
        return this.setOfCapabilityNames.contains(string);
    }

    String getFallBackForDevice(String string) {
        if (!this.isDeviceIn(string)) {
            return "";
        }
        if (string.equals("generic")) {
            return "generic";
        }
        return ((Element)this.deviceElementsList.get(string)).getAttributeValue("fall_back");
    }

    ArrayList getFallBackPathToRoot(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (string.equals("generic")) {
            arrayList.add("generic");
            return arrayList;
        }
        if (!this.isDeviceIn(string)) {
            return arrayList;
        }
        String string2 = string;
        while (!string2.equals("generic")) {
            arrayList.add(string2);
            string2 = this.getFallBackForDevice(string2);
        }
        arrayList.add("generic");
        return arrayList;
    }

    boolean isCapabilityDefinedInDevice(String string, String string2) {
        if (!this.isDeviceIn(string)) {
            return false;
        }
        if (!this.isCapabilityIn(string2)) {
            return false;
        }
        Element element = (Element)this.deviceElementsList.get(string);
        Elements elements = element.getChildElements("group");
        if (elements.size() == 0) {
            return false;
        }
        Elements elements2 = null;
        int n = 0;
        while (n < elements.size()) {
            elements2 = elements.get(n).getChildElements("capability");
            if (elements2.size() != 0) {
                int n2 = 0;
                while (n2 < elements2.size()) {
                    if (elements2.get(n2).getAttributeValue("name").equals(string2)) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    String getDeviceWhereCapabilityIsDefined(String string, String string2) {
        if (!this.isDeviceIn(string)) {
            return "";
        }
        if (!this.isCapabilityIn(string2)) {
            return "";
        }
        if (this.isCapabilityDefinedInDevice(string, string2)) {
            return string;
        }
        String string3 = string;
        while (!this.isCapabilityDefinedInDevice(string3, string2)) {
            string3 = this.getFallBackForDevice(string3);
        }
        return string3;
    }

    String getCapabilityValueForDeviceAndCapability(String string, String string2) {
        if (!this.isDeviceIn(string)) {
            return "";
        }
        if (!this.isCapabilityIn(string2)) {
            return "";
        }
        if (string.equals("generic")) {
            return (String)this.genericCapabilityNameValues.get(string2);
        }
        String string3 = this.getDeviceWhereCapabilityIsDefined(string, string2);
        Element element = (Element)this.deviceElementsList.get(string3);
        Elements elements = element.getChildElements("group");
        Elements elements2 = null;
        int n = 0;
        while (n < elements.size()) {
            elements2 = elements.get(n).getChildElements("capability");
            if (elements2.size() != 0) {
                int n2 = 0;
                while (n2 < elements2.size()) {
                    if (elements2.get(n2).getAttributeValue("name").equals(string2)) {
                        return elements2.get(n2).getAttributeValue("value");
                    }
                    ++n2;
                }
            }
            ++n;
        }
        System.out.println("WURFL non e' corretto");
        return "";
    }

    public String getDeviceIDFromUA(String string) {
        Object v = this.listOfUAWithDeviceID.get(string);
        if (v == null) {
            return "generic";
        }
        return (String)v;
    }

    public String getDeviceIDFromUALoose(String string) {
        if (string.length() == 0) {
            return "generic";
        }
        Object v = this.listOfUAWithDeviceID.get(string);
        if (v != null) {
            return (String)v;
        }
        String string2 = string;
        while (string2.length() > 5) {
            Iterator iterator = this.listOfUAWithDeviceID.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3.indexOf(string2) == -1) continue;
                return (String)this.listOfUAWithDeviceID.get(string3);
            }
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string.indexOf("UP.Browser/7") != -1) {
            return "opwv_v7_generic";
        }
        if (string.indexOf("UP.Browser/6") != -1) {
            return "opwv_v6_generic";
        }
        if (string.indexOf("UP.Browser/5") != -1) {
            return "upgui_generic";
        }
        if (string.indexOf("UP.Browser/4") != -1) {
            return "uptext_generic";
        }
        if (string.indexOf("Series60") != -1) {
            return "nokia_generic_series60";
        }
        if (string.indexOf("Mozilla/4.0") != -1) {
            return "generic_web_browser";
        }
        return "generic";
    }

    private void patch_parse_error(String string) {
        System.out.println("Fatal error in parsing wurfl patch file ");
        System.out.println(string);
        throw new WurflException(string);
    }

    private void merge_group_capabilities(Element element, Element element2) {
        Elements elements = element2.getChildElements("capability");
        Elements elements2 = element.getChildElements("capability");
        int n = 0;
        while (n < elements.size()) {
            Element element3 = elements.get(n);
            String string = element3.getAttributeValue("name");
            boolean bl = false;
            Element element4 = null;
            int n2 = 0;
            while (n2 < elements2.size()) {
                element4 = elements2.get(n2);
                String string2 = element4.getAttributeValue("name");
                if (string2.equals(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                element.removeChild((Node)element4);
                element.appendChild(element3.copy());
            } else {
                element.appendChild(element3.copy());
            }
            ++n;
        }
    }

    public String toXML() {
        if (this.doc != null) {
            try {
                return Wurfl.toPrettyXML(this.doc);
            }
            catch (Exception exception) {
                return "<sorry>WURFL has not been parsed yet!</sorry>";
            }
        }
        return "<sorry>WURFL has not been parsed yet!</sorry>";
    }

    public static void toPrettyXML(Document document, OutputStream outputStream) throws Exception {
        Serializer serializer = new Serializer(outputStream);
        serializer.setIndent(2);
        serializer.setMaxLength(200);
        serializer.setPreserveBaseURI(false);
        serializer.write(document);
        serializer.flush();
        outputStream.close();
    }

    public static String toPrettyXML(Document document) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Wurfl.toPrettyXML(document, byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public HashSet getDeviceIdSet() {
        return this.deviceIdSet;
    }

    public HashMap getListOfUAWithDeviceID() {
        return this.listOfUAWithDeviceID;
    }

    public int getNumberOfDevices() {
        return this.numberOfDevices;
    }

    public HashMap getDeviceElementsList() {
        return this.deviceElementsList;
    }

    public ArrayList getListOfCapabilities() {
        return this.listOfCapabilities;
    }

    public int getNumberOfCapabilities() {
        return this.numberOfCapabilities;
    }

    public HashMap getListOfGroups() {
        return this.listOfGroups;
    }

    public Elements getDevices() {
        return this.devices;
    }

    public HashSet getSetOfCapabilityNames() {
        return this.setOfCapabilityNames;
    }
}

