/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import net.sourceforge.wurfl.wall.TagUtil;
import net.sourceforge.wurfl.wurflapi.CapabilityMatrix;
import net.sourceforge.wurfl.wurflapi.ListManager;
import net.sourceforge.wurfl.wurflapi.ObjectsManager;
import net.sourceforge.wurfl.wurflapi.UAManager;

public class WallDocument
extends TagSupport {
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    private static CapabilityMatrix cm = null;
    private static UAManager uam = null;
    private static ListManager lm = null;
    String warning = "";
    String UA = "";
    String device_id = "";
    String capability_value = "";
    String title = "";
    boolean enforce_title = false;
    boolean uplink = false;
    boolean use_wml_extensions = false;
    boolean use_xhtml_extensions = false;
    HashMap allCapas = null;
    protected boolean disable_wml_extensions = false;
    protected boolean disable_xhtml_extensions = false;
    boolean css_menu_requested = false;
    String formAction = "";
    String formMethod = "";
    ArrayList formFields = new ArrayList();
    HashMap hiddenFields = new HashMap();

    void setCSSMenuRequested() {
        this.css_menu_requested = true;
    }

    boolean getCSSMenuRequested() {
        return this.css_menu_requested;
    }

    void setDocumentTitle(String string) {
        this.title = string;
    }

    String getDocumentTitle() {
        return this.title;
    }

    void setEnforceTitle(boolean bl) {
        this.enforce_title = bl;
    }

    boolean getEnforceTitle() {
        return this.enforce_title;
    }

    void setFormAction(String string) {
        this.formAction = string;
    }

    String getFormAction() {
        return this.formAction;
    }

    void setFormMethod(String string) {
        this.formMethod = string;
    }

    String getFormMethod() {
        return this.formMethod;
    }

    void addFieldName(String string) {
        this.formFields.add(string);
    }

    ArrayList getFormFields() {
        return this.formFields;
    }

    void addHiddenField(String string, String string2) {
        this.hiddenFields.put(string, string2);
    }

    HashMap getHiddenFields() {
        return this.hiddenFields;
    }

    boolean getUseWMLExtensions() {
        return this.use_wml_extensions;
    }

    boolean getUseXHTMLExtensions() {
        return this.use_xhtml_extensions;
    }

    public void setDisable_wml_extensions(boolean bl) {
        this.disable_wml_extensions = bl;
    }

    public void setDisable_wml_extensions(String string) {
        this.disable_wml_extensions = string.equalsIgnoreCase("true");
    }

    public void setDisable_xhtml_extensions(boolean bl) {
        this.disable_xhtml_extensions = bl;
    }

    public void setDisable_xhtml_extensions(String string) {
        this.disable_xhtml_extensions = string.equalsIgnoreCase("true");
    }

    public int doStartTag() throws JspException {
        this.css_menu_requested = false;
        this.title = "";
        this.enforce_title = false;
        this.formAction = "";
        this.formMethod = "";
        this.formFields.clear();
        this.hiddenFields.clear();
        this.uplink = false;
        try {
            boolean bl;
            String string;
            cm = ObjectsManager.getCapabilityMatrixInstance();
            uam = ObjectsManager.getUAManagerInstance();
            lm = ObjectsManager.getListManagerInstance();
            this.request = (HttpServletRequest)this.pageContext.getRequest();
            this.response = (HttpServletResponse)this.pageContext.getResponse();
            this.warning = TagUtil.checkCapability("preferred_markup");
            if (this.warning.length() > 0) {
                throw new JspException(this.warning);
            }
            this.UA = TagUtil.getUA(this.request);
            this.device_id = uam.getDeviceIDFromUALoose(this.UA);
            this.capability_value = cm.getCapabilityForDevice(this.device_id, "preferred_markup");
            this.capability_value = TagUtil.getWallMarkup(this.capability_value);
            this.allCapas = lm.getCapabilitiesForDeviceID(this.device_id);
            this.pageContext.setAttribute("capabilities", (Object)this.allCapas);
            if (this.capability_value.indexOf("xhtmlmp") == -1 && this.capability_value.indexOf("chtml") == -1 && this.capability_value.indexOf("wml") == -1) {
                throw new JspException("No Valid mark up found: " + this.capability_value);
            }
            this.uplink = TagUtil.isUplink(this.request);
            if (this.capability_value.indexOf("xhtmlmp") != -1) {
                this.warning = TagUtil.checkCapability("opwv_xhtml_extensions_support");
                if (this.warning.length() > 0) {
                    throw new JspException(this.warning);
                }
                string = cm.getCapabilityForDevice(this.device_id, "opwv_xhtml_extensions_support");
                bl = string.equals("true");
                boolean bl2 = this.use_xhtml_extensions = !this.disable_xhtml_extensions && this.uplink && bl;
            }
            if (this.capability_value.indexOf("wml") != -1) {
                this.response.setContentType("text/vnd.wap.wml");
                this.warning = TagUtil.checkCapability("opwv_wml_extensions_support");
                if (this.warning.length() > 0) {
                    throw new JspException(this.warning);
                }
                string = cm.getCapabilityForDevice(this.device_id, "opwv_wml_extensions_support");
                bl = string.equals("true");
                this.use_wml_extensions = !this.disable_wml_extensions && this.uplink && bl;
            }
            return 1;
        }
        catch (Exception exception) {
            System.out.println("Error in Wurfl(2): tag 'document': " + exception.getMessage());
            System.out.println("Error: " + exception.toString());
            return 0;
        }
    }

    public int doEndTag() {
        try {
            JspWriter jspWriter = this.pageContext.getOut();
            if (this.capability_value.indexOf("wml") != -1) {
                jspWriter.print("</wml>");
            }
            if (this.capability_value.indexOf("xhtmlmp") != -1 || this.capability_value.indexOf("chtml") != -1) {
                jspWriter.print("</html>");
            }
        }
        catch (IOException iOException) {
            System.out.println("Error in Tag document: " + iOException);
        }
        return 6;
    }
}

