/*
 * Decompiled with CFR 0.152.
 */
package org.xbean.spring.generator;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.xbean.spring.generator.GeneratorPlugin;
import org.xbean.spring.generator.LogFacade;
import org.xbean.spring.generator.MappingLoader;
import org.xbean.spring.generator.NamespaceMapping;

public class SchemaGenerator {
    private final MappingLoader mappingLoader;
    private final GeneratorPlugin[] plugins;
    private final LogFacade log;

    public SchemaGenerator(LogFacade log, MappingLoader mappingLoader, GeneratorPlugin[] plugins) {
        this.log = log;
        this.mappingLoader = mappingLoader;
        this.plugins = plugins;
    }

    public void generate() throws IOException {
        Set namespaces = this.mappingLoader.loadNamespaces();
        if (namespaces.isEmpty()) {
            this.log.log("Warning: no namespaces found!");
        }
        Iterator iterator = namespaces.iterator();
        while (iterator.hasNext()) {
            NamespaceMapping namespaceMapping = (NamespaceMapping)iterator.next();
            for (int i = 0; i < this.plugins.length; ++i) {
                GeneratorPlugin plugin = this.plugins[i];
                plugin.generate(namespaceMapping);
            }
        }
    }
}

