/*
 * Decompiled with CFR 0.152.
 */
package org.xbean.spring.jndi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.xbean.spring.jndi.NameParserImpl;

public class DefaultContext
implements Context,
Serializable {
    private static final long serialVersionUID = -5754338187296859149L;
    protected static final NameParser nameParser = new NameParserImpl();
    private boolean freeze = false;
    protected final Hashtable environment;
    protected final Map bindings;
    protected final Map treeBindings;
    private boolean frozen = false;
    private String nameInNamespace = "";
    public static final String SEPARATOR = "/";

    public DefaultContext() {
        this.environment = new Hashtable();
        this.bindings = new HashMap();
        this.treeBindings = new HashMap();
    }

    public DefaultContext(Hashtable env) {
        this.environment = env == null ? new Hashtable() : new Hashtable(env);
        this.bindings = new HashMap();
        this.treeBindings = new HashMap();
    }

    public DefaultContext(Hashtable environment, Map bindings) {
        this.environment = environment == null ? new Hashtable() : new Hashtable(environment);
        this.bindings = bindings;
        this.treeBindings = new HashMap();
        this.frozen = true;
    }

    public DefaultContext(Hashtable environment, Map bindings, String nameInNamespace) {
        this(environment, bindings);
        this.nameInNamespace = nameInNamespace;
    }

    protected DefaultContext(DefaultContext clone, Hashtable env) {
        this.bindings = clone.bindings;
        this.treeBindings = clone.treeBindings;
        this.environment = new Hashtable(env);
    }

    protected DefaultContext(DefaultContext clone, Hashtable env, String nameInNamespace) {
        this(clone, env);
        this.nameInNamespace = nameInNamespace;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    public Object lookup(String name) throws NamingException {
        if (name.length() == 0) {
            return this;
        }
        Object result = this.treeBindings.get(name);
        if (result == null) {
            result = this.bindings.get(name);
        }
        if (result == null) {
            int pos = name.indexOf(58);
            if (pos > 0) {
                String scheme = name.substring(0, pos);
                Context ctx = NamingManager.getURLContext(scheme, this.environment);
                if (ctx == null) {
                    throw new NamingException("scheme " + scheme + " not recognized");
                }
                return ctx.lookup(name);
            }
            CompositeName path = new CompositeName(name);
            if (path.size() == 0) {
                return this;
            }
            String first = path.get(0);
            Object obj = this.bindings.get(first);
            if (obj == null) {
                throw new NameNotFoundException(name);
            }
            if (obj instanceof Context && path.size() > 1) {
                Context subContext = (Context)obj;
                obj = subContext.lookup(path.getSuffix(1));
            }
            return obj;
        }
        if (result instanceof LinkRef) {
            LinkRef ref = (LinkRef)result;
            result = this.lookup(ref.getLinkName());
        }
        if (result instanceof Reference) {
            try {
                result = NamingManager.getObjectInstance(result, null, null, this.environment);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw (NamingException)new NamingException("could not look up : " + name).initCause(e);
            }
        }
        if (result instanceof DefaultContext) {
            String prefix = this.getNameInNamespace();
            if (prefix.length() > 0) {
                prefix = prefix + SEPARATOR;
            }
            result = new DefaultContext((DefaultContext)result, this.environment, prefix + name);
        }
        return result;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public String composeName(String name, String prefix) throws NamingException {
        CompositeName result = new CompositeName(prefix);
        result.addAll(new CompositeName(name));
        return result.toString();
    }

    public NamingEnumeration list(String name) throws NamingException {
        Object o = this.lookup(name);
        if (o == this) {
            return new ListEnumeration();
        }
        if (o instanceof Context) {
            return ((Context)o).list("");
        }
        throw new NotContextException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Object o = this.lookup(name);
        if (o == this) {
            return new ListBindingEnumeration();
        }
        if (o instanceof Context) {
            return ((Context)o).listBindings("");
        }
        throw new NotContextException();
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void bind(Name name, Object value) throws NamingException {
        this.bind(name.toString(), value);
    }

    public void bind(String name, Object value) throws NamingException {
        this.checkFrozen();
        this.internalBind(name, value);
    }

    public void close() throws NamingException {
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public void rebind(Name name, Object value) throws NamingException {
        this.rebind(name.toString(), value);
    }

    public void rebind(String name, Object value) throws NamingException {
        this.checkFrozen();
        this.internalBind(name, value, true);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.checkFrozen();
        Object value = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, value);
    }

    public void rename(String oldName, String newName) throws NamingException {
        Object value = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, value);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        this.checkFrozen();
        this.internalBind(name, null, true);
    }

    public Map getEntries() {
        return new HashMap(this.bindings);
    }

    public void setEntries(Map entries) throws NamingException {
        if (entries != null) {
            Iterator iter = entries.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.internalBind(name, value);
            }
        }
    }

    public boolean isFreeze() {
        return this.freeze;
    }

    public void setFreeze(boolean freeze) {
        this.freeze = freeze;
    }

    protected Map internalBind(String name, Object value) throws NamingException {
        return this.internalBind(name, value, false);
    }

    protected Map internalBind(String name, Object value, boolean allowRebind) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new NamingException("Invalid Name " + name);
        }
        if (this.frozen) {
            throw new NamingException("Read only");
        }
        HashMap<String, Object> newBindings = new HashMap<String, Object>();
        int pos = name.indexOf(47);
        if (pos == -1) {
            Object oldValue = this.treeBindings.put(name, value);
            if (!allowRebind && oldValue != null) {
                throw new NamingException("Something already bound at " + name);
            }
            this.bindings.put(name, value);
            newBindings.put(name, value);
        } else {
            String segment = name.substring(0, pos);
            if (segment == null || segment.length() == 0) {
                throw new NamingException("Invalid segment " + segment);
            }
            Object o = this.treeBindings.get(segment);
            if (o == null) {
                o = this.newContext();
                this.treeBindings.put(segment, o);
                this.bindings.put(segment, o);
                newBindings.put(segment, o);
            } else if (!(o instanceof DefaultContext)) {
                throw new NamingException("Something already bound where a subcontext should go");
            }
            DefaultContext defaultContext = (DefaultContext)o;
            String remainder = name.substring(pos + 1);
            Map subBindings = defaultContext.internalBind(remainder, value, allowRebind);
            Iterator iterator = subBindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String subName = segment + SEPARATOR + (String)entry.getKey();
                Object bound = entry.getValue();
                this.treeBindings.put(subName, bound);
                newBindings.put(subName, bound);
            }
        }
        return newBindings;
    }

    protected void checkFrozen() throws OperationNotSupportedException {
        if (this.isFreeze()) {
            throw new OperationNotSupportedException("JNDI context is frozen!");
        }
    }

    protected DefaultContext newContext() {
        return new DefaultContext();
    }

    private class ListBindingEnumeration
    extends LocalNamingEnumeration {
        private ListBindingEnumeration() {
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry entry = this.getNext();
            return new Binding((String)entry.getKey(), entry.getValue());
        }
    }

    private class ListEnumeration
    extends LocalNamingEnumeration {
        private ListEnumeration() {
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Map.Entry entry = this.getNext();
            return new NameClassPair((String)entry.getKey(), entry.getValue().getClass().getName());
        }
    }

    private abstract class LocalNamingEnumeration
    implements NamingEnumeration {
        private Iterator i;

        private LocalNamingEnumeration() {
            this.i = DefaultContext.this.bindings.entrySet().iterator();
        }

        public boolean hasMore() throws NamingException {
            return this.i.hasNext();
        }

        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        protected Map.Entry getNext() {
            return (Map.Entry)this.i.next();
        }

        public void close() throws NamingException {
        }

        public abstract /* synthetic */ Object next() throws NamingException;

        public abstract /* synthetic */ Object nextElement();
    }
}

