/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateColumnTag;

public class HibernateColumnTagImpl
extends XDocletTag
implements HibernateColumnTag {
    public static final String NAME = "hibernate.column";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("name", "unique-key", "index", "check", "comment", "scale", "unique", "not-null", "length", "precision", "sql-type", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateColumnTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getName_() {
        boolean required = true;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getUniqueKey() {
        boolean required = false;
        String result = this.getNamedParameter("unique-key");
        if (required && result == null) {
            this.bomb("unique-key=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getIndex() {
        boolean required = false;
        String result = this.getNamedParameter("index");
        if (required && result == null) {
            this.bomb("index=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getCheck() {
        boolean required = false;
        String result = this.getNamedParameter("check");
        if (required && result == null) {
            this.bomb("check=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getComment() {
        boolean required = false;
        String result = this.getNamedParameter("comment");
        if (required && result == null) {
            this.bomb("comment=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getScale() {
        boolean required = false;
        String result = this.getNamedParameter("scale");
        if (required && result == null) {
            this.bomb("scale=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getUnique() {
        boolean required = false;
        String result = this.getNamedParameter("unique");
        if (required && result == null) {
            this.bomb("unique=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Boolean getNotNull() {
        boolean required = false;
        String result = this.getNamedParameter("not-null");
        if (required && result == null) {
            this.bomb("not-null=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        Integer retVal = null;
        if (result != null) {
            try {
                retVal = Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return retVal;
    }

    public String getPrecision() {
        boolean required = false;
        String result = this.getNamedParameter("precision");
        if (required && result == null) {
            this.bomb("precision=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getSqlType() {
        boolean required = false;
        String result = this.getNamedParameter("sql-type");
        if (required && result == null) {
            this.bomb("sql-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getName_();
        this.getUniqueKey();
        this.getIndex();
        this.getCheck();
        this.getComment();
        this.getScale();
        this.getUnique();
        this.getNotNull();
        this.getLength();
        this.getPrecision();
        this.getSqlType();
    }
}

