/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateKeyManyToOneTag;

public class HibernateKeyManyToOneTagImpl
extends XDocletTag
implements HibernateKeyManyToOneTag {
    public static final String NAME = "hibernate.key-many-to-one";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("lazy", "foreign-key", "access", "position", "class", "column", "entity-name", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateKeyManyToOneTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Boolean getLazy() {
        boolean required = false;
        String result = this.getNamedParameter("lazy");
        if (required && result == null) {
            this.bomb("lazy=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getForeignKey() {
        boolean required = false;
        String result = this.getNamedParameter("foreign-key");
        if (required && result == null) {
            this.bomb("foreign-key=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getAccess() {
        boolean required = false;
        String result = this.getNamedParameter("access");
        if (required && result == null) {
            this.bomb("access=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Integer getPosition() {
        boolean required = false;
        String result = this.getNamedParameter("position");
        if (required && result == null) {
            this.bomb("position=\"???\" must be specified.");
        }
        Integer retVal = null;
        if (result == null) {
            result = "1";
        }
        if (result != null) {
            try {
                retVal = Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("position=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return retVal;
    }

    public String getClass_() {
        boolean required = false;
        String result = this.getNamedParameter("class");
        if (required && result == null) {
            this.bomb("class=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getEntityName() {
        boolean required = false;
        String result = this.getNamedParameter("entity-name");
        if (required && result == null) {
            this.bomb("entity-name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getLazy();
        this.getForeignKey();
        this.getAccess();
        this.getPosition();
        this.getClass_();
        this.getColumn();
        this.getEntityName();
    }
}

