/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateListIndexTag;

public class HibernateListIndexTagImpl
extends XDocletTag
implements HibernateListIndexTag {
    public static final String NAME = "hibernate.list-index";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("base", "node", "column", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateListIndexTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Integer getBase() {
        boolean required = false;
        String result = this.getNamedParameter("base");
        if (required && result == null) {
            this.bomb("base=\"???\" must be specified.");
        }
        Integer retVal = null;
        if (result != null) {
            try {
                retVal = Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("base=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return retVal;
    }

    public String getNode() {
        boolean required = false;
        String result = this.getNamedParameter("node");
        if (required && result == null) {
            this.bomb("node=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getBase();
        this.getNode();
        this.getColumn();
    }
}

