/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernatePropertyTag;

public class HibernatePropertyTagImpl
extends XDocletTag
implements HibernatePropertyTag {
    public static final String NAME = "hibernate.property";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("optimistic-lock", "type", "index", "insert", "access", "not-null", "formula", "precision", "lazy", "properties-name", "scale", "node", "unique", "length", "update", "name", "column", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernatePropertyTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Boolean getOptimisticLock() {
        boolean required = false;
        String result = this.getNamedParameter("optimistic-lock");
        if (required && result == null) {
            this.bomb("optimistic-lock=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getType() {
        boolean required = false;
        String result = this.getNamedParameter("type");
        if (required && result == null) {
            this.bomb("type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getIndex() {
        boolean required = false;
        String result = this.getNamedParameter("index");
        if (required && result == null) {
            this.bomb("index=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getInsert() {
        boolean required = false;
        String result = this.getNamedParameter("insert");
        if (required && result == null) {
            this.bomb("insert=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getAccess() {
        boolean required = false;
        String result = this.getNamedParameter("access");
        if (required && result == null) {
            this.bomb("access=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getNotNull() {
        boolean required = false;
        String result = this.getNamedParameter("not-null");
        if (required && result == null) {
            this.bomb("not-null=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getFormula() {
        boolean required = false;
        String result = this.getNamedParameter("formula");
        if (required && result == null) {
            this.bomb("formula=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getPrecision() {
        boolean required = false;
        String result = this.getNamedParameter("precision");
        if (required && result == null) {
            this.bomb("precision=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getLazy() {
        boolean required = false;
        String result = this.getNamedParameter("lazy");
        if (required && result == null) {
            this.bomb("lazy=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getPropertiesName() {
        boolean required = false;
        String result = this.getNamedParameter("properties-name");
        if (required && result == null) {
            this.bomb("properties-name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getScale() {
        boolean required = false;
        String result = this.getNamedParameter("scale");
        if (required && result == null) {
            this.bomb("scale=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getNode() {
        boolean required = false;
        String result = this.getNamedParameter("node");
        if (required && result == null) {
            this.bomb("node=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getUnique() {
        boolean required = false;
        String result = this.getNamedParameter("unique");
        if (required && result == null) {
            this.bomb("unique=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        Integer retVal = null;
        if (result != null) {
            try {
                retVal = Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return retVal;
    }

    public Boolean getUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("update");
        if (required && result == null) {
            this.bomb("update=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getName_() {
        boolean required = false;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getOptimisticLock();
        this.getType();
        this.getIndex();
        this.getInsert();
        this.getAccess();
        this.getNotNull();
        this.getFormula();
        this.getPrecision();
        this.getLazy();
        this.getPropertiesName();
        this.getScale();
        this.getNode();
        this.getUnique();
        this.getLength();
        this.getUpdate();
        this.getName_();
        this.getColumn();
    }
}

