/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.web;

import com.thoughtworks.qdox.model.DocletTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.OutputValidator;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.generama.defaults.XMLOutputValidator;
import org.xdoclet.plugin.web.ClassAttributeComparator;
import org.xdoclet.plugin.web.ClassTagPredicate;
import org.xdoclet.plugin.web.WebUtils;
import org.xdoclet.plugin.web.qtags.TagLibrary;

public class WebPlugin
extends QDoxPlugin {
    private String publicId = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    private String systemId = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static Map filterInterface = new HashMap();
    private static String servletInterface;
    private static String[] allWebInterfaces;
    private WebUtils webUtils;
    private String servletversion = "2.3";
    protected String mergedir;

    public WebPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)jellyTemplateEngine, metadataProvider, writerMapper);
        this.setMultioutput(false);
        this.setFilereplace("web.xml");
        this.setOutputValidator((OutputValidator)new XMLOutputValidator(WebUtils.DTDs));
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public String getServletversion() {
        return this.servletversion;
    }

    public void setServletversion(String servletversion) {
        this.servletversion = servletversion;
    }

    public WebUtils getWebUtils() {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils(this.servletversion);
        }
        return this.webUtils;
    }

    public boolean needsDoctype() {
        return !this.getWebUtils().isMinimumServletVersion("2.4");
    }

    public boolean needsSchema() {
        return this.getWebUtils().isMinimumServletVersion("2.4");
    }

    public String getSchemaXmlNs() {
        return this.needsSchema() ? "http://java.sun.com/xml/ns/j2ee" : null;
    }

    public String getSchemaXmlNsXsi() {
        return this.needsSchema() ? "http://www.w3.org/2001/XMLSchema-instance" : null;
    }

    public String getSchemaXsiSchemaLocation() {
        return this.needsSchema() ? "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd" : null;
    }

    public Collection getFilters() {
        ArrayList filters = new ArrayList();
        String[] interfaces = (String[])filterInterface.get(this.servletversion);
        if (interfaces != null) {
            ClassTagPredicate predicate = new ClassTagPredicate(interfaces, "web.filter");
            CollectionUtils.select((Collection)this.metadataProvider.getMetadata(), (Predicate)predicate, filters);
            Collections.sort(filters, new ClassAttributeComparator("web.filter", "order"));
        }
        return filters;
    }

    public Collection getServlets() {
        ArrayList servlets = new ArrayList();
        ClassTagPredicate predicate = new ClassTagPredicate(servletInterface, "web.servlet");
        CollectionUtils.select((Collection)this.metadataProvider.getMetadata(), (Predicate)predicate, servlets);
        Collections.sort(servlets, new ClassAttributeComparator("web.servlet", "order"));
        return servlets;
    }

    public Collection getAllWebClasses() {
        ArrayList all = new ArrayList();
        ClassTagPredicate predicate = new ClassTagPredicate(allWebInterfaces);
        CollectionUtils.select((Collection)this.metadataProvider.getMetadata(), (Predicate)predicate, all);
        return this.metadataProvider.getMetadata();
    }

    public boolean needsServletRunAs(DocletTag tag) {
        return tag.getNamedParameter("run-as") != null && this.servletversion.compareTo("2.3") >= 0;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getMergedir() {
        return this.mergedir;
    }

    public void setMergedir(String mergedir) {
        this.mergedir = mergedir;
    }

    static {
        filterInterface.put("2.3", new String[]{"javax.servlet.Filter"});
        filterInterface.put("2.4", new String[]{"javax.servlet.Filter"});
        servletInterface = "javax.servlet.Servlet";
        allWebInterfaces = new String[]{"javax.servlet.Filter", servletInterface, "javax.servlet.ServletContextAttributeListener", "javax.servlet.ServletContextListener", "javax.servlet.ServletRequestAttributeListener", "javax.servlet.ServletRequestListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionBindingListener", "javax.servlet.http.HttpSessionListener"};
    }
}

