/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.IOException;
import junit.framework.TestCase;
import xjavadoc.Token;
import xjavadoc.XDoc;
import xjavadoc.XTag;

public class XDocTest
extends TestCase {
    private XDoc doc;

    public XDocTest(String name) {
        super(name);
    }

    public void setUp() throws IOException {
        String javadoc = "/********************** This is in the doc too      \n * JUnit test for\n   * JavaDocReader.    \n   * This is sentence number two.   \n     * @ejb:bla * bla\n *   @param what about\n * this one?\n *Or this\n     one?\n * @oh dear=\"we\" should=\"go to bed\"\n */";
        Token token = Token.newToken(0);
        token.image = javadoc;
        this.doc = new XDoc(token, null, null);
    }

    public void testFirstSentence() throws IOException {
        XDocTest.assertEquals((String)"This is in the doc too JUnit test for JavaDocReader.", (String)this.doc.getFirstSentence());
        XDocTest.assertEquals((String)"This is in the doc too JUnit test for JavaDocReader. This is sentence number two.", (String)this.doc.getCommentText());
    }

    public void testCommentChange() throws IOException {
        this.doc.setCommentText("foo bar baz blurge. And this is second sentence");
        XDocTest.assertEquals((String)"foo bar baz blurge.", (String)this.doc.getFirstSentence());
        XDocTest.assertEquals((String)"foo bar baz blurge. And this is second sentence", (String)this.doc.getCommentText());
    }

    public void testTagCreationAndRemoval() throws IOException {
        this.doc.addTag("foo:bar", "blurge=\"bang\" baz=\"blabla\" what's up?");
        XDocTest.assertTrue((boolean)this.doc.hasTag("foo:bar"));
        this.doc.removeTag(this.doc.getTag("foo:bar"));
        XDocTest.assertTrue((!this.doc.hasTag("foo:bar") ? 1 : 0) != 0);
    }

    public void testTagChange() throws IOException {
        this.doc.addTag("foo:bar", "blurge=\"bang\" baz=\"blabla\" what's up?");
        XDocTest.assertEquals((String)this.doc.getTagAttributeValue("foo:bar", "blurge"), (String)"bang");
        XTag tag = this.doc.getTag("foo:bar");
        tag.setAttribute("blurge", "foo");
        XDocTest.assertEquals((String)tag.getAttributeValue("blurge"), (String)"foo");
        tag.setAttribute("foo", "bar");
        XDocTest.assertEquals((String)this.doc.getTagAttributeValue("foo:bar", "blurge"), (String)"foo");
        XDocTest.assertEquals((String)this.doc.getTagAttributeValue("foo:bar", "foo"), (String)"bar");
    }
}

