/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.tags;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.LogFactory;
import xjavadoc.XTagFactory;

public final class TagIntrospector {
    static /* synthetic */ Class class$xjavadoc$XTag;
    static /* synthetic */ Class class$xjavadoc$tags$TagIntrospector;

    public void registerTags(String classpath, XTagFactory tagFactory) {
        LogFactory.getLog(this.getClass()).debug((Object)"Registering tags");
        StringTokenizer st = new StringTokenizer(classpath, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            File classpathElement = new File(st.nextToken());
            if (classpathElement.exists()) {
                List javaBeans = this.findJavaBeans(classpathElement);
                this.registerTags(javaBeans, tagFactory);
                continue;
            }
            LogFactory.getLog(this.getClass()).warn((Object)(classpathElement.getAbsolutePath() + " was on classpath, but doesn't exist."));
        }
    }

    private void registerTags(List javaBeans, XTagFactory tagFactory) {
        Iterator i = javaBeans.iterator();
        while (i.hasNext()) {
            Class javaBean;
            if ((class$xjavadoc$XTag == null ? TagIntrospector.class$("xjavadoc.XTag") : class$xjavadoc$XTag).isAssignableFrom(javaBean = (Class)i.next())) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(javaBean);
                    String tagName = beanInfo.getBeanDescriptor().getName();
                    LogFactory.getLog((Class)(class$xjavadoc$tags$TagIntrospector == null ? TagIntrospector.class$("xjavadoc.tags.TagIntrospector") : class$xjavadoc$tags$TagIntrospector)).debug((Object)("Registering @" + tagName + " -> " + javaBean.getName()));
                    tagFactory.registerTagClass(tagName, javaBean);
                }
                catch (IntrospectionException e) {
                    LogFactory.getLog(this.getClass()).debug((Object)("No BeanInfo for " + javaBean.getName()));
                }
                continue;
            }
            LogFactory.getLog(this.getClass()).debug((Object)(javaBean.getName() + " isn't a xjavadoc.XTag class. Ignoring"));
        }
    }

    private List findJavaBeans(File dirOrJar) {
        ArrayList result = new ArrayList();
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{dirOrJar.toURL()}, this.getClass().getClassLoader());
            Manifest manifest = null;
            if (dirOrJar.isDirectory()) {
                try {
                    manifest = new Manifest(new FileInputStream(new File(dirOrJar, "META-INF/MANIFEST.MF")));
                }
                catch (IOException e) {}
            } else {
                try {
                    JarFile jarFile = new JarFile(dirOrJar);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (manifest != null) {
                Iterator<String> entryNames = manifest.getEntries().keySet().iterator();
                while (entryNames.hasNext()) {
                    String entryName = entryNames.next();
                    if (!entryName.endsWith(".class")) continue;
                    Attributes attributes = manifest.getAttributes(entryName);
                    LogFactory.getLog(this.getClass()).debug((Object)("ENTRY:" + entryName));
                    String javaBean = attributes.getValue("Java-Bean");
                    if (!"true".equalsIgnoreCase(javaBean)) continue;
                    String className = entryName.substring(0, entryName.length() - 6);
                    className = className.replace('/', '.');
                    try {
                        Class<?> beanClass = classLoader.loadClass(className);
                        result.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        String errorMessage = className + " was declared as a Java-Bean in the manifest, but the class was not found.";
                        LogFactory.getLog(this.getClass()).error((Object)errorMessage, (Throwable)e);
                        throw new IllegalStateException(errorMessage);
                    }
                }
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

