/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999,2000 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.apache.org.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLComponentManager;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/**
 * @author Stubs generated by DesignDoc on Mon Oct 09 22:31:27 PDT 2000
 * @version $Id: DesignDoc.java,v 1.1.2.1 2000/09/15 21:57:12 andyc Exp $
 */
public class XMLParser
    implements XMLComponentManager {

    //
    // Data
    //

    /** fSymbolTable */
    protected SymbolTable fSymbolTable;

    /** fEntityManager */
    protected XMLEntityManager fEntityManager;

    /** fErrorReporter */
    protected XMLErrorReporter fErrorReporter;

    /** fNamespaces */
    protected boolean fNamespaces;

    /** fValidation */
    protected boolean fValidation;

    /** fDynamicValidation */
    protected boolean fDynamicValidation;

    /** fContinueAfterFatalError */
    protected boolean fContinueAfterFatalError;

    //
    // Constructors
    //

    /**
     * 
     */
    public XMLParser() {
    }

    /**
     * 
     * 
     * @param symbolTable 
     */
    protected XMLParser(SymbolTable symbolTable) {
    }

    //
    // Methods
    //

    /**
     * setFeature
     * 
     * @param featureId 
     * @param state 
     */
    public void setFeature(String featureId, boolean state)
        throws SAXNotRecognizedException, SAXNotSupportedException {
    } // setFeature

    /**
     * getFeature
     * 
     * @param featureId 
     * 
     * @return 
     */
    public boolean getFeature(String featureId)
        throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    } // getFeature

    /**
     * setProperty
     * 
     * @param propertyId 
     * @param value 
     */
    public void setProperty(String propertyId, Object value)
        throws SAXNotRecognizedException, SAXNotSupportedException {
    } // setProperty

    /**
     * getProperty
     * 
     * @param propertyId 
     * 
     * @return 
     */
    public Object getProperty(String propertyId)
        throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    } // getProperty

    /**
     * setEntityResolver
     * 
     * @param entityResolver 
     */
    public void setEntityResolver(EntityResolver entityResolver) {
    } // setEntityResolver

    /**
     * setErrorHandler
     * 
     * @param errorHandler 
     */
    public void setErrorHandler(ErrorHandler errorHandler) {
    } // setErrorHandler

    /**
     * parse
     * 
     * @param systemId 
     */
    public void parse(String systemId)
        throws IOException, SAXException {
    } // parse

    /**
     * parse
     * 
     * @param inputSource 
     */
    public void parse(InputSource inputSource)
        throws IOException, SAXException {
    } // parse

    //
    // XMLComponentManager methods
    //

    /**
     * getFeature
     * 
     * @param featureId 
     * 
     * @return 
     */
    public boolean getFeature(String featureId)
        throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    } // getFeature

    /**
     * getProperty
     * 
     * @param propertyId 
     * 
     * @return 
     */
    public Object getProperty(String propertyId)
        throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    } // getProperty

} // class XMLParser
