/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;
import sax.helpers.AttributesImpl;

public class Writer
extends DefaultHandler
implements LexicalHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected Locator fLocator;
    protected boolean fXML11;
    protected boolean fInCDATA;

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        this.fXML11 = false;
        this.fInCDATA = false;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(string);
            if (string2 != null && string2.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(string2);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.fElementDepth == 0) {
            if (this.fLocator != null) {
                this.fXML11 = "1.1".equals(this.getVersion());
                this.fLocator = null;
            }
            if (!this.fCanonical) {
                if (this.fXML11) {
                    this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                } else {
                    this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                this.fOut.flush();
            }
        }
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(string3);
        if (attributes != null) {
            attributes = this.sortAttributes(attributes);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(attributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attributes.getValue(n2), true);
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fInCDATA) {
            this.normalizeAndPrint(cArray, n, n2, false);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                this.fOut.print(cArray[n + n3]);
                ++n3;
            }
        }
        this.fOut.flush();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
        this.fOut.flush();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(string3);
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fOut.print("<![CDATA[");
            this.fInCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fInCDATA = false;
            this.fOut.print("]]>");
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.fOut.print("<!--");
            int n3 = 0;
            while (n3 < n2) {
                this.fOut.print(cArray[n + n3]);
                ++n3;
            }
            this.fOut.print("-->");
            this.fOut.flush();
        }
    }

    protected Attributes sortAttributes(Attributes attributes) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getQName(n2);
            int n3 = attributesImpl.getLength();
            int n4 = 0;
            while (n4 < n3) {
                if (string.compareTo(attributesImpl.getQName(n4)) < 0) break;
                ++n4;
            }
            attributesImpl.insertAttributeAt(n4, string, attributes.getType(n2), attributes.getValue(n2));
            ++n2;
        }
        return attributesImpl;
    }

    protected void normalizeAndPrint(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c, bl);
            ++n2;
        }
    }

    protected void normalizeAndPrint(char[] cArray, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < n2) {
            this.normalizeAndPrint(cArray[n + n3], bl);
            ++n3;
        }
    }

    protected void normalizeAndPrint(char c, boolean bl) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (bl) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || bl && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected String getVersion() {
        if (this.fLocator == null) {
            return null;
        }
        String string = null;
        Method method = null;
        try {
            method = this.fLocator.getClass().getMethod("getXMLVersion", new Class[0]);
            if (method != null) {
                string = (String)method.invoke((Object)this.fLocator, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = false;
        var8_8 = 0;
        while (var8_8 < var0.length) {
            block43: {
                var9_9 = var0[var8_8];
                if (!var9_9.startsWith("-")) ** GOTO lbl-1000
                var10_10 = var9_9.substring(1);
                if (var10_10.equals("p")) {
                    if (++var8_8 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var11_19 = var0[var8_8];
                    try {
                        var2_2 = XMLReaderFactory.createXMLReader((String)var11_19);
                    }
                    catch (Exception var12_24) {
                        try {
                            var13_25 = ParserFactory.makeParser((String)var11_19);
                            var2_2 = new ParserAdapter(var13_25);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception var13_26) {
                            var2_2 = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)var11_19 + ")");
                            var12_24.printStackTrace(System.err);
                        }
                    }
                } else if (var10_10.equalsIgnoreCase("n")) {
                    var3_3 = var10_10.equals("n");
                } else if (var10_10.equalsIgnoreCase("v")) {
                    var4_4 = var10_10.equals("v");
                } else if (var10_10.equalsIgnoreCase("s")) {
                    var5_5 = var10_10.equals("s");
                } else if (var10_10.equalsIgnoreCase("f")) {
                    var6_6 = var10_10.equals("f");
                } else if (var10_10.equalsIgnoreCase("c")) {
                    var7_7 = var10_10.equals("c");
                } else if (var10_10.equals("h")) {
                    Writer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var2_2 == null) {
                        try {
                            var2_2 = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                        catch (Exception var10_11) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            var10_11.printStackTrace(System.err);
                            break block43;
                        }
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                    }
                    catch (SAXException var10_12) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/validation", var4_4);
                    }
                    catch (SAXException var10_13) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema", var5_5);
                    }
                    catch (SAXNotRecognizedException var10_14) {
                    }
                    catch (SAXNotSupportedException var11_20) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var6_6);
                    }
                    catch (SAXNotRecognizedException var10_15) {
                    }
                    catch (SAXNotSupportedException var11_21) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    if (var1_1 == null) {
                        var1_1 = new Writer();
                        try {
                            var1_1.setOutput(System.out, "UTF8");
                        }
                        catch (UnsupportedEncodingException var10_16) {
                            System.err.println("error: Unable to set output. Exiting.");
                            System.exit(1);
                        }
                    }
                    var2_2.setContentHandler(var1_1);
                    var2_2.setErrorHandler(var1_1);
                    try {
                        var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", var1_1);
                    }
                    catch (SAXException var10_17) {
                        // empty catch block
                    }
                    var1_1.setCanonical(var7_7);
                    try {
                        var2_2.parse(var9_9);
                    }
                    catch (SAXParseException var10_18) {
                    }
                    catch (Exception var11_22) {
                        System.err.println("error: Parse error occurred - " + var11_22.getMessage());
                        if (var11_22 instanceof SAXException && (var12_23 = ((SAXException)var11_22).getException()) != null) {
                            var11_19 = var12_23;
                        }
                        var11_19.printStackTrace(System.err);
                    }
                }
            }
            ++var8_8;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -c | -C  Turn on/off Canonical XML output.");
        System.err.println("           NOTE: This is not W3C canonical output.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
    }
}

