/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;
import org.opensaml.SAMLSignedObject;
import org.opensaml.SAMLStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAssertion
extends SAMLSignedObject
implements Cloneable {
    protected String assertionId = new SAMLIdentifier().toString();
    protected String issuer = null;
    protected Date issueInstant = new Date();
    protected Date notBefore = null;
    protected Date notOnOrAfter = null;
    protected ArrayList conditions = new ArrayList();
    protected ArrayList advice = new ArrayList();
    protected ArrayList statements = new ArrayList();

    protected void insertSignature() throws SAMLException {
        this.root.appendChild(this.getSignatureElement());
    }

    public SAMLAssertion() {
    }

    public SAMLAssertion(String string, Date date, Date date2, Collection collection, Collection collection2, Collection collection3) throws SAMLException {
        this.issuer = string;
        this.notBefore = date;
        this.notOnOrAfter = date2;
        if (collection != null) {
            this.conditions.addAll(collection);
        }
        if (collection2 != null) {
            this.advice.addAll(collection2);
        }
        if (collection3 != null) {
            this.statements.addAll(collection3);
        }
    }

    public SAMLAssertion(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAssertion(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAssertion.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() requires saml:Assertion at root");
        }
        if (Integer.parseInt(element.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLAssertion.fromDOM() detected incompatible assertion major version of " + element.getAttributeNS(null, "MajorVersion"));
        }
        this.issuer = element.getAttributeNS(null, "Issuer");
        this.assertionId = element.getAttributeNS(null, "AssertionID");
        element.setIdAttributeNode(element.getAttributeNodeNS(null, "AssertionID"), true);
        try {
            SimpleDateFormat simpleDateFormat = null;
            String string = element.getAttributeNS(null, "IssueInstant");
            int n = string.indexOf(46);
            simpleDateFormat = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.issueInstant = simpleDateFormat.parse(string);
            Element element2 = XML.getFirstChildElement(element);
            while (element2 != null) {
                Element element3;
                if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions")) {
                    if (element2.hasAttributeNS(null, "NotBefore")) {
                        this.notBefore = simpleDateFormat.parse(element2.getAttributeNS(null, "NotBefore"));
                    }
                    if (element2.hasAttributeNS(null, "NotOnOrAfter")) {
                        this.notOnOrAfter = simpleDateFormat.parse(element2.getAttributeNS(null, "NotOnOrAfter"));
                    }
                    element3 = XML.getFirstChildElement(element2);
                    while (element3 != null) {
                        this.conditions.add(SAMLCondition.getInstance(element3));
                        element3 = XML.getNextSiblingElement(element3);
                    }
                } else if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice")) {
                    element3 = XML.getFirstChildElement(element2);
                    while (element3 != null) {
                        if (XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
                            this.advice.add(element3.getFirstChild().getNodeValue());
                        } else if (XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                            this.advice.add(new SAMLAssertion(element3));
                        } else {
                            this.advice.add(element3);
                        }
                        element3 = XML.getNextSiblingElement(element3);
                    }
                } else if (!XML.isElementNamed(element2, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
                    this.statements.add(SAMLStatement.getInstance(element2));
                }
                element2 = XML.getNextSiblingElement(element2);
            }
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() detected an invalid datetime while parsing assertion", (Exception)parseException);
        }
        this.checkValidity();
    }

    public String getId() {
        return this.assertionId;
    }

    public void setId(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.assertionId = string;
        if (this.root != null) {
            this.unsign();
            ((Element)this.root).getAttributeNodeNS(null, "AssertionID").setNodeValue(string);
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("issuer cannot be null");
        }
        this.issuer = string;
        if (this.root != null) {
            this.unsign();
            ((Element)this.root).getAttributeNodeNS(null, "Issuer").setNodeValue(string);
        }
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        if (this.root != null) {
            this.unsign();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            ((Element)this.root).getAttributeNodeNS(null, "IssueInstant").setNodeValue(simpleDateFormat.format(date));
        }
        this.issueInstant = date;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date date) {
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
            if (this.notBefore != null) {
                element.removeAttributeNS(null, "NotBefore");
                if (date == null && this.notOnOrAfter == null && this.conditions.size() == 0) {
                    this.root.removeChild(element);
                }
            }
            if (date != null) {
                if (element == null) {
                    element = (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions"), this.root.getFirstChild());
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                element.setAttributeNS(null, "NotBefore", simpleDateFormat.format(date));
            }
        }
        this.notBefore = date;
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Date date) {
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
            if (this.notOnOrAfter != null) {
                element.removeAttributeNS(null, "NotOnOrAfter");
                if (this.notBefore == null && date == null && this.conditions.size() == 0) {
                    this.root.removeChild(element);
                }
            }
            if (date != null) {
                if (element == null) {
                    element = (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions"), this.root.getFirstChild());
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                element.setAttributeNS(null, "NotOnOrAfter", simpleDateFormat.format(date));
            }
        }
        this.notOnOrAfter = date;
    }

    public Iterator getConditions() {
        return this.conditions.iterator();
    }

    public void setConditions(Collection collection) throws SAMLException {
        while (this.conditions.size() > 0) {
            this.removeCondition(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addCondition((SAMLCondition)iterator.next());
            }
        }
    }

    public void addCondition(SAMLCondition sAMLCondition) throws SAMLException {
        if (sAMLCondition != null) {
            if (this.root != null) {
                this.unsign();
                Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
                if (element == null) {
                    this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions"), this.root.getFirstChild());
                }
                element.appendChild(sAMLCondition.toDOM(this.root.getOwnerDocument()));
            }
        } else {
            throw new IllegalArgumentException("c cannot be null");
        }
        this.conditions.add(sAMLCondition);
    }

    public void removeCondition(int n) throws IndexOutOfBoundsException {
        this.conditions.remove(n);
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
            if (this.conditions.size() == 0 && this.notBefore == null && this.notOnOrAfter == null) {
                this.root.removeChild(element);
                return;
            }
            Element element2 = XML.getFirstChildElement(element);
            while (element2 != null && n > 0) {
                element2 = XML.getNextSiblingElement(element2);
                --n;
            }
            if (element2 != null) {
                element.removeChild(element2);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Iterator getAdvice() {
        return this.advice.iterator();
    }

    public void setAdvice(Collection collection) throws SAMLException {
        while (this.advice.size() > 0) {
            this.removeAdvice(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAdvice(iterator.next());
            }
        }
    }

    public void addAdvice(Object object) throws SAMLException {
        if (object != null && (object instanceof String || object instanceof SAMLAssertion || object instanceof Element && !((Element)object).getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion"))) {
            if (this.root != null) {
                Document document = this.root.getOwnerDocument();
                Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
                if (object instanceof String && !XML.isEmpty((String)object)) {
                    Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
                    element2.appendChild(document.createTextNode((String)object));
                    element.appendChild(element2);
                } else if (object instanceof SAMLAssertion) {
                    element.appendChild(((SAMLAssertion)object).toDOM(document));
                } else if (object instanceof Element) {
                    element.appendChild(document.adoptNode((Element)object));
                }
            }
        } else {
            throw new IllegalArgumentException("SAMLAssertion.addAdvice() can only process Strings, SAMLAssertions, or DOM elements from a non-saml namespace");
        }
        this.advice.add(object);
    }

    public void removeAdvice(int n) throws IndexOutOfBoundsException {
        this.advice.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
            Element element2 = XML.getFirstChildElement(element);
            while (element2 != null && n > 0) {
                element2 = XML.getNextSiblingElement(element2);
                --n;
            }
            if (element2 != null) {
                element.removeChild(element2);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Iterator getStatements() {
        return this.statements.iterator();
    }

    public void setStatements(Collection collection) throws SAMLException {
        while (this.statements.size() > 0) {
            this.removeStatement(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addStatement((SAMLStatement)iterator.next());
            }
        }
    }

    public void addStatement(SAMLStatement sAMLStatement) throws SAMLException {
        if (sAMLStatement != null) {
            if (this.root != null) {
                this.unsign();
                if (this.statements.size() > 0) {
                    Node node = ((SAMLStatement)this.statements.get((int)(this.statements.size() - 1))).root;
                    this.root.insertBefore(sAMLStatement.toDOM(this.root.getOwnerDocument()), node.getNextSibling());
                } else {
                    this.root.appendChild(sAMLStatement.toDOM(this.root.getOwnerDocument()));
                }
            }
        } else {
            throw new IllegalArgumentException("s cannot be null");
        }
        this.statements.add(sAMLStatement);
    }

    public void removeStatement(int n) throws IndexOutOfBoundsException {
        this.statements.remove(n);
        if (this.root != null) {
            this.unsign();
            Element element = XML.getFirstChildElement(this.root);
            if (XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions")) {
                element = XML.getNextSiblingElement(element);
            }
            if (XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice")) {
                element = XML.getNextSiblingElement(element);
            }
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        Iterator iterator;
        Object object;
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
            return this.root;
        }
        if (this.issuer == null || this.issuer.length() == 0 || this.statements == null || this.statements.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.toDOM() requires issuer and at least one statement");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
        element.setAttributeNS(null, "MajorVersion", "1");
        element.setAttributeNS(null, "MinorVersion", this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? "0" : "1");
        element.setAttributeNS(null, "AssertionID", this.assertionId);
        element.setIdAttributeNS(null, "AssertionID", true);
        element.setAttributeNS(null, "Issuer", this.issuer);
        element.setAttributeNS(null, "IssueInstant", simpleDateFormat.format(this.issueInstant));
        if (this.conditions.size() > 0 || this.notBefore != null || this.notOnOrAfter != null) {
            object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
            if (this.notBefore != null) {
                object.setAttributeNS(null, "NotBefore", simpleDateFormat.format(this.notBefore));
            }
            if (this.notOnOrAfter != null) {
                object.setAttributeNS(null, "NotOnOrAfter", simpleDateFormat.format(this.notOnOrAfter));
            }
            element.appendChild((Node)object);
            iterator = this.conditions.iterator();
            while (iterator.hasNext()) {
                object.appendChild(((SAMLCondition)iterator.next()).toDOM(document, false));
            }
        }
        if (this.advice.size() > 0) {
            object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
            iterator = this.advice.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String && !XML.isEmpty((String)e)) {
                    Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
                    element2.appendChild(document.createTextNode((String)e));
                    object.appendChild(element2);
                    continue;
                }
                if (e instanceof SAMLAssertion) {
                    object.appendChild(((SAMLAssertion)e).toDOM(document, false));
                    continue;
                }
                if (!(e instanceof Element)) continue;
                object.appendChild(document.adoptNode((Element)e));
            }
            element.appendChild((Node)object);
        }
        object = this.statements.iterator();
        while (object.hasNext()) {
            element.appendChild(((SAMLStatement)object.next()).toDOM(document, false));
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.issuer) || this.statements.size() == 0) {
            throw new MalformedException("Assertion is invalid, must have Issuer and at least one Statement");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAssertion sAMLAssertion = (SAMLAssertion)super.clone();
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            sAMLAssertion.conditions.add(((SAMLCondition)iterator.next()).clone());
        }
        iterator = this.advice.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                sAMLAssertion.advice.add(e);
                continue;
            }
            if (e instanceof SAMLAssertion) {
                sAMLAssertion.advice.add(((SAMLAssertion)e).clone());
                continue;
            }
            sAMLAssertion.advice.add(((Element)e).cloneNode(true));
        }
        iterator = this.statements.iterator();
        while (iterator.hasNext()) {
            sAMLAssertion.statements.add(((SAMLStatement)iterator.next()).clone());
        }
        return sAMLAssertion;
    }
}

