/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.codehaus.xfire.addressing.AbstactAddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.EndpointReference;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;
import org.codehaus.yom.Node;

public class AddressingHeadersFactory200408
extends AbstactAddressingHeadersFactory {
    public AddressingHeaders createHeaders(Element root) {
        Element faultTo;
        Element replyTo;
        AddressingHeaders headers = new AddressingHeaders();
        Element from = root.getFirstChildElement("From", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        if (from != null) {
            headers.setFrom(this.createEPR(from));
        }
        if ((replyTo = root.getFirstChildElement("ReplyTo", "http://schemas.xmlsoap.org/ws/2004/08/addressing")) != null) {
            headers.setReplyTo(this.createEPR(replyTo));
        }
        if ((faultTo = root.getFirstChildElement("FaultTo", "http://schemas.xmlsoap.org/ws/2004/08/addressing")) != null) {
            headers.setFaultTo(this.createEPR(faultTo));
        }
        headers.setMessageID(this.getChildValue(root, "MessageID", "http://schemas.xmlsoap.org/ws/2004/08/addressing"));
        Element relatesTo = root.getFirstChildElement("RelatesTo", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        if (relatesTo != null) {
            headers.setRelatesTo(relatesTo.getValue());
            String relation = relatesTo.getAttributeValue("RelationshipType");
            if (relation != null) {
                headers.setRelationshipType(AddressingHeadersFactory200408.stringToQName(relatesTo, relation));
            } else {
                headers.setRelationshipType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Reply"));
            }
        }
        headers.setTo(this.getChildValue(root, "To", "http://schemas.xmlsoap.org/ws/2004/08/addressing"));
        headers.setAction(this.getChildValue(root, "Action", "http://schemas.xmlsoap.org/ws/2004/08/addressing"));
        return headers;
    }

    public EndpointReference createEPR(Element eprElement) {
        EndpointReference epr = new EndpointReference();
        ArrayList<Element> anyContent = null;
        Elements elements = eprElement.getChildElements();
        String version = eprElement.getNamespaceURI();
        for (int i = 0; i < elements.size(); ++i) {
            int j;
            Elements polEls;
            Element e = elements.get(i);
            if (!e.getNamespaceURI().equals(version)) continue;
            if (e.getLocalName().equals("Address")) {
                epr.setAddress(e.getValue());
                continue;
            }
            if (e.getLocalName().equals("ServiceName")) {
                epr.setServiceName(AddressingHeadersFactory200408.elementToQName(e));
                epr.setEndpointName(e.getAttributeValue("EndpointName", version));
                continue;
            }
            if (e.getLocalName().equals("InterfaceName")) {
                epr.setInterfaceName(AddressingHeadersFactory200408.elementToQName(e));
                continue;
            }
            if (e.getLocalName().equals("Policies")) {
                ArrayList<Element> policies = new ArrayList<Element>();
                polEls = e.getChildElements();
                for (j = 0; j < polEls.size(); ++j) {
                    policies.add(polEls.get(j));
                }
                epr.setPolicies(policies);
                continue;
            }
            if (e.getLocalName().equals("ReferenceProperties")) {
                ArrayList<Element> props = new ArrayList<Element>();
                polEls = e.getChildElements();
                for (j = 0; j < polEls.size(); ++j) {
                    props.add(polEls.get(j));
                }
                epr.setReferenceProperties(props);
                continue;
            }
            if (e.getLocalName().equals("ReferenceParameters")) {
                ArrayList<Element> params = new ArrayList<Element>();
                polEls = e.getChildElements();
                for (j = 0; j < polEls.size(); ++j) {
                    params.add(polEls.get(j));
                }
                epr.setReferenceParameters(params);
                continue;
            }
            if (anyContent == null) {
                anyContent = new ArrayList<Element>();
            }
            anyContent.add(e);
        }
        if (anyContent != null) {
            epr.setAny(anyContent);
        }
        return epr;
    }

    public boolean hasHeaders(Element root) {
        return root.getFirstChildElement("Action", "http://schemas.xmlsoap.org/ws/2004/08/addressing") != null;
    }

    public void writeHeaders(Element root, AddressingHeaders headers) {
        String ns = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        root.addNamespaceDeclaration("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        if (headers.getTo() != null) {
            Element to = new Element("wsa:To", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            to.appendChild(headers.getTo());
            root.appendChild((Node)to);
        }
        if (headers.getAction() != null) {
            Element action = new Element("wsa:Action", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            action.appendChild(headers.getAction());
            root.appendChild((Node)action);
        }
        if (headers.getFaultTo() != null) {
            Element faultTo = new Element("wsa:FaultTo", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            root.appendChild((Node)faultTo);
            this.writeEPR(faultTo, headers.getFaultTo());
        }
        if (headers.getFrom() != null) {
            Element from = new Element("wsa:From", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            root.appendChild((Node)from);
            this.writeEPR(from, headers.getFrom());
        }
        if (headers.getMessageID() != null) {
            Element messageId = new Element("wsa:MessageID", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            messageId.appendChild(headers.getMessageID());
            root.appendChild((Node)messageId);
        }
        if (headers.getRelatesTo() != null) {
            Element relatesTo = new Element("wsa:RelatesTo", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            relatesTo.appendChild(headers.getRelatesTo());
            root.appendChild((Node)relatesTo);
            if (headers.getRelationshipType() != null) {
                String value = AddressingHeadersFactory200408.qnameToString(root, headers.getRelationshipType());
                relatesTo.addAttribute(new Attribute("RelationshipType", value));
            }
        }
        if (headers.getReplyTo() != null) {
            Element replyTo = new Element("wsa:ReplyTo", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            root.appendChild((Node)replyTo);
            this.writeEPR(replyTo, headers.getReplyTo());
        }
    }

    public void writeEPR(Element root, EndpointReference epr) {
        String ns = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        Element address = new Element("wsa:Address", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
        address.appendChild(epr.getAddress());
        root.appendChild((Node)address);
        if (epr.getServiceName() != null) {
            Element serviceName = new Element("wsa:ServiceName", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            serviceName.appendChild(AddressingHeadersFactory200408.qnameToString((Element)root.getParent(), epr.getServiceName()));
            root.appendChild((Node)serviceName);
            if (epr.getInterfaceName() != null) {
                String value = AddressingHeadersFactory200408.qnameToString((Element)root.getParent(), epr.getInterfaceName());
                serviceName.addAttribute(new Attribute("PortType", value));
            }
        }
    }

    public String getAnonymousUri() {
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
    }
}

