/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.AddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeadersFactory200408;
import org.codehaus.xfire.addressing.AddressingHeadersFactory200502;
import org.codehaus.xfire.addressing.EndpointReference;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.yom.Element;

public class AddressingInHandler
extends AbstractHandler {
    public static final Object ADRESSING_HEADERS = "xfire-ws-adressing-headers";
    public static final Object ADRESSING_FACTORY = "xfire-ws-adressing-factory";
    private List factories = new ArrayList();

    public AddressingInHandler() {
        this.createFactories();
    }

    public void createFactories() {
        this.factories.add(new AddressingHeadersFactory200502());
        this.factories.add(new AddressingHeadersFactory200408());
    }

    public String getPhase() {
        return "pre-dispatch";
    }

    public void invoke(MessageContext context) throws Exception {
        Iterator itr = this.factories.iterator();
        while (itr.hasNext()) {
            OperationInfo op;
            InMessage msg;
            Element header;
            AddressingHeadersFactory factory = (AddressingHeadersFactory)itr.next();
            if (!factory.hasHeaders(header = (msg = context.getInMessage()).getHeader())) continue;
            AddressingHeaders headers = factory.createHeaders(header);
            msg.setProperty(ADRESSING_HEADERS, headers);
            msg.setProperty(ADRESSING_FACTORY, factory);
            Service service = this.getService(headers, context);
            if (service != null) {
                context.setService(service);
            }
            if ((op = service.getServiceInfo().getOperationByAction(headers.getAction())) == null) {
                throw new XFireFault("Action '" + headers.getAction() + "' was not found for service " + headers.getTo(), "Sender");
            }
            MessageExchange exchange = context.createMessageExchange(op);
            context.setExchange(exchange);
            EndpointReference faultTo = headers.getFaultTo();
            OutMessage faultMsg = null;
            faultMsg = faultTo != null ? this.processEPR(context, faultTo, headers, factory) : this.createDefaultMessage(context, headers, factory);
            exchange.setFaultMessage(faultMsg);
            EndpointReference replyTo = headers.getReplyTo();
            OutMessage outMessage = null;
            outMessage = replyTo != null ? this.processEPR(context, replyTo, headers, factory) : this.createDefaultMessage(context, headers, factory);
            exchange.setOutMessage(outMessage);
        }
    }

    private OutMessage createDefaultMessage(MessageContext context, AddressingHeaders inHeaders, AddressingHeadersFactory factory) {
        OutMessage outMessage = context.getOutMessage();
        AddressingHeaders headers = new AddressingHeaders();
        headers.setTo(factory.getAnonymousUri());
        headers.setAction(inHeaders.getAction() + "Ack");
        outMessage.setProperty(ADRESSING_HEADERS, headers);
        outMessage.setProperty(ADRESSING_FACTORY, factory);
        return outMessage;
    }

    protected OutMessage processEPR(MessageContext context, EndpointReference epr, AddressingHeaders inHeaders, AddressingHeadersFactory factory) throws XFireFault, Exception {
        String addr = epr.getAddress();
        if (addr == null) {
            throw new XFireFault("Invalid ReplyTo address.", "Sender");
        }
        OutMessage outMessage = addr.equals(factory.getAnonymousUri()) ? new OutMessage("urn:xfire:channel:backchannel") : new OutMessage(addr);
        outMessage.setSoapVersion(context.getExchange().getInMessage().getSoapVersion());
        Transport t = context.getXFire().getTransportManager().getTransportForUri(addr);
        if (t == null) {
            throw new XFireFault("URL was not recognized: " + addr, "Sender");
        }
        outMessage.setChannel(t.createChannel());
        AddressingHeaders headers = new AddressingHeaders();
        headers.setTo(addr);
        headers.setAction(inHeaders.getAction() + "Ack");
        outMessage.setProperty(ADRESSING_HEADERS, headers);
        outMessage.setProperty(ADRESSING_FACTORY, factory);
        return outMessage;
    }

    protected Service getService(AddressingHeaders headers, MessageContext context) {
        if (headers.getTo() == null) {
            return null;
        }
        int i = headers.getTo().lastIndexOf(47);
        return context.getXFire().getServiceRegistry().getService(headers.getTo().substring(i + 1));
    }
}

