/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.stax;

import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.AbstractMessageWriter;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.stax.AttributeWriter;
import org.codehaus.xfire.util.NamespaceHelper;

public class ElementWriter
extends AbstractMessageWriter
implements MessageWriter {
    private XMLStreamWriter writer;
    private String namespace;
    private String name;
    private String prefix;

    public ElementWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public ElementWriter(XMLStreamWriter writer, String name, String namespace) {
        this(writer, name, namespace, null);
    }

    public ElementWriter(XMLStreamWriter streamWriter, QName name) {
        this(streamWriter, name.getLocalPart(), name.getNamespaceURI());
    }

    public ElementWriter(XMLStreamWriter writer, String name, String namespace, String prefix) {
        this.writer = writer;
        this.namespace = namespace;
        this.name = name;
        this.prefix = prefix;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", e);
        }
    }

    public ElementWriter(OutputStream os, String name, String namespace) throws XMLStreamException {
        XMLOutputFactory ofactory = XMLOutputFactory.newInstance();
        this.writer = ofactory.createXMLStreamWriter(os);
        this.namespace = namespace;
        this.name = name;
        try {
            this.writeStartElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", e);
        }
    }

    private void writeStartElement() throws XMLStreamException {
        if (this.namespace != null) {
            boolean declare = false;
            String decPrefix = this.writer.getPrefix(this.namespace);
            if (this.prefix == null && decPrefix == null) {
                declare = true;
                this.prefix = NamespaceHelper.getUniquePrefix(this.writer);
            } else if (this.prefix == null) {
                this.prefix = decPrefix;
            } else if (!this.prefix.equals(decPrefix)) {
                declare = true;
            }
            this.writer.writeStartElement(this.prefix, this.name, this.namespace);
            if (declare) {
                this.writer.setPrefix(this.prefix, this.namespace);
                this.writer.writeNamespace(this.prefix, this.namespace);
            }
        } else {
            this.writer.writeStartElement(this.name);
        }
    }

    public void writeValue(Object value) {
        try {
            if (value != null) {
                this.writer.writeCharacters(value.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", e);
        }
    }

    public MessageWriter getElementWriter(String name) {
        return new ElementWriter(this.writer, name, this.namespace);
    }

    public MessageWriter getElementWriter(String name, String ns) {
        return new ElementWriter(this.writer, name, ns);
    }

    public MessageWriter getElementWriter(QName qname) {
        return new ElementWriter(this.writer, qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void close() {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error writing document.", e);
        }
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.writer;
    }

    public MessageWriter getAttributeWriter(String name) {
        return new AttributeWriter(this.writer, name, this.namespace);
    }

    public MessageWriter getAttributeWriter(String name, String namespace) {
        return new AttributeWriter(this.writer, name, namespace);
    }

    public MessageWriter getAttributeWriter(QName qname) {
        return new AttributeWriter(this.writer, qname.getLocalPart(), qname.getLocalPart());
    }
}

