/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type;

import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.AbstractTypeCreator;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.aegis.type.basic.XMLBeanTypeInfo;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.yom.Document;
import org.codehaus.yom.Element;
import org.codehaus.yom.stax.StaxBuilder;
import org.codehaus.yom.xpath.YOMXPath;
import org.jaxen.JaxenException;

public class XMLTypeCreator
extends AbstractTypeCreator {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$aegis$type$XMLTypeCreator == null ? (class$org$codehaus$xfire$aegis$type$XMLTypeCreator = XMLTypeCreator.class$("org.codehaus.xfire.aegis.type.XMLTypeCreator")) : class$org$codehaus$xfire$aegis$type$XMLTypeCreator));
    private Map documents = new HashMap();
    static /* synthetic */ Class class$org$codehaus$xfire$aegis$type$XMLTypeCreator;

    protected Document getDocument(Class clazz) {
        Document doc = (Document)this.documents.get(clazz.getName());
        if (doc != null) {
            return doc;
        }
        String path = '/' + clazz.getName().replace('.', '/') + ".aegis.xml";
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            doc = new StaxBuilder().build(is);
            this.documents.put(clazz.getName(), doc);
            return doc;
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error loading file " + path), (Throwable)e);
            return null;
        }
    }

    public Type createCollectionType(AbstractTypeCreator.TypeClassInfo info) {
        return super.createCollectionType(info, (Class)info.getGenericType());
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        Element mapping = this.findMapping(pd.getReadMethod().getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        Element propertyEl = this.getMatch(mapping, "./property[@name='" + pd.getName() + "']");
        if (propertyEl == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        AbstractTypeCreator.TypeClassInfo info = new AbstractTypeCreator.TypeClassInfo();
        info.setTypeClass(pd.getReadMethod().getReturnType());
        this.setComponentType(info, propertyEl);
        this.setKeyType(info, propertyEl);
        info.setName(this.createQName(propertyEl, propertyEl.getAttributeValue("mappedName")));
        return info;
    }

    protected Element findMapping(Class clazz) {
        Document doc = this.getDocument(clazz);
        if (doc == null) {
            return null;
        }
        Element mapping = this.getMatch(doc, "/mappings/mapping[@uri='" + this.getTypeMapping().getEncodingStyleURI() + "']");
        if (mapping == null) {
            mapping = this.getMatch(doc, "/mappings/mapping");
        }
        return mapping;
    }

    public Type createDefaultType(AbstractTypeCreator.TypeClassInfo info) {
        Element mapping = this.findMapping(info.getTypeClass());
        if (mapping != null) {
            XMLBeanTypeInfo btinfo = new XMLBeanTypeInfo(this.getTypeMapping(), info.getTypeClass(), mapping);
            btinfo.setTypeMapping(this.getTypeMapping());
            BeanType type = new BeanType(btinfo);
            QName name = btinfo.getSchemaType();
            if (name == null) {
                name = this.createQName(info.getTypeClass());
            }
            type.setSchemaType(name);
            type.setTypeClass(info.getTypeClass());
            type.setTypeMapping(this.getTypeMapping());
            return type;
        }
        return this.nextCreator.createDefaultType(info);
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(Method m, int index) {
        Element mapping = this.findMapping(m.getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(m, index);
        }
        AbstractTypeCreator.TypeClassInfo info = new AbstractTypeCreator.TypeClassInfo();
        if (index >= 0) {
            if (index >= m.getParameterTypes().length) {
                throw new XFireRuntimeException("Method " + m + " does not have a parameter at index " + index);
            }
            List nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/parameter[@index='" + index + "']/parent::*");
            if (nodes.size() == 0) {
                return this.nextCreator.createClassInfo(m, index);
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return this.nextCreator.createClassInfo(m, index);
            }
            info.setTypeClass(m.getParameterTypes()[index]);
            Element parameter = this.getMatch(bestMatch, "parameter[@index='" + index + "']");
            this.setComponentType(info, parameter);
            this.setKeyType(info, parameter);
            info.setName(this.createQName(parameter, parameter.getAttributeValue("mappedName")));
        } else {
            List nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/return-type/parent::*");
            if (nodes.size() == 0) {
                return this.nextCreator.createClassInfo(m, index);
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return this.nextCreator.createClassInfo(m, index);
            }
            info.setTypeClass(m.getReturnType());
            Element rtElement = bestMatch.getFirstChildElement("return-type");
            String componentType = rtElement.getAttributeValue("componentType");
            if (componentType != null) {
                try {
                    info.setGenericType(ClassLoaderUtils.loadClass(componentType, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Unable to load mapping class " + componentType));
                }
            }
            info.setName(this.createQName(rtElement, rtElement.getAttributeValue("mappedName")));
        }
        return info;
    }

    protected void setComponentType(AbstractTypeCreator.TypeClassInfo info, Element parameter) {
        String componentType = parameter.getAttributeValue("componentType");
        if (componentType != null) {
            try {
                info.setGenericType(ClassLoaderUtils.loadClass(componentType, this.getClass()));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Unable to load mapping class " + componentType));
            }
        }
    }

    protected void setKeyType(AbstractTypeCreator.TypeClassInfo info, Element parameter) {
        String componentType = parameter.getAttributeValue("keyType");
        if (componentType != null) {
            try {
                info.setKeyType(ClassLoaderUtils.loadClass(componentType, this.getClass()));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Unable to load mapping class " + componentType));
            }
        }
    }

    private Element getBestMatch(Element mapping, Method method, List availableNodes) {
        Element element;
        Iterator iterator;
        List nodes = this.getMatches(mapping, "./method[@name='" + method.getName() + "']");
        if (availableNodes != null) {
            nodes.retainAll(availableNodes);
        }
        if (nodes.size() == 0) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return (Element)nodes.get(0);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            iterator = nodes.iterator();
            while (iterator.hasNext()) {
                element = (Element)iterator.next();
                Element match = this.getMatch(element, "parameter[@index='" + i + "']");
                if (match == null || match.getAttributeValue("type") == null || match.getAttributeValue("type").equals(parameterType.getName())) continue;
                iterator.remove();
            }
        }
        if (nodes.size() == 1) {
            return (Element)nodes.get(0);
        }
        Element bestCandidate = null;
        int highestSpecified = 0;
        iterator = nodes.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            int availableParameters = element.getChildElements("parameter").size();
            if (availableParameters <= highestSpecified) continue;
            bestCandidate = element;
            highestSpecified = availableParameters;
        }
        return bestCandidate;
    }

    private Element getMatch(Object doc, String xpath) {
        try {
            YOMXPath path = new YOMXPath(xpath);
            return (Element)path.selectSingleNode(doc);
        }
        catch (JaxenException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }

    private List getMatches(Object doc, String xpath) {
        try {
            YOMXPath path = new YOMXPath(xpath);
            List result = path.selectNodes(doc);
            return result;
        }
        catch (JaxenException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }

    protected QName createQName(Element e, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(this.getTypeMapping().getEncodingStyleURI(), value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = e.getNamespaceURI(prefix);
        if (ns == null || localName == null) {
            throw new XFireRuntimeException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

