/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class ArrayType
extends Type {
    private QName componentName;
    private static final Log logger = LogFactory.getLog((Class)(class$org$codehaus$xfire$aegis$type$basic$ArrayType == null ? (class$org$codehaus$xfire$aegis$type$basic$ArrayType = ArrayType.class$("org.codehaus.xfire.aegis.type.basic.ArrayType")) : class$org$codehaus$xfire$aegis$type$basic$ArrayType));
    static /* synthetic */ Class class$org$codehaus$xfire$aegis$type$basic$ArrayType;
    static /* synthetic */ Class class$java$lang$Object;

    public ArrayType() {
        this.setNillable(true);
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        try {
            Type compType = this.getComponentType();
            ArrayList<Object> values = new ArrayList<Object>();
            while (reader.hasMoreElementReaders()) {
                values.add(compType.readObject(reader.getNextElementReader(), context));
            }
            return this.makeArray(this.getComponentType().getTypeClass(), values);
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", e);
        }
    }

    protected Object makeArray(Class arrayType, List values) {
        if (Integer.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Integer.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Long.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Long.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Short.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Short.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Double.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Double.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Float.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Float.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Byte.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Byte.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        if (Boolean.TYPE.equals(arrayType)) {
            Object[] objects = values.toArray();
            Object array = Array.newInstance(Boolean.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
            return array;
        }
        return values.toArray((Object[])Array.newInstance(this.getComponentType().getTypeClass(), values.size()));
    }

    public void writeObject(Object values, MessageWriter writer, MessageContext context) throws XFireFault {
        block11: {
            Class arrayType;
            String name;
            String ns;
            Type type;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        if (values == null) {
                                            return;
                                        }
                                        type = this.getComponentType();
                                        ns = null;
                                        ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                                        name = type.getSchemaType().getLocalPart();
                                        if (type == null) {
                                            throw new XFireRuntimeException("Couldn't find type for " + type.getTypeClass() + ".");
                                        }
                                        if (!(class$java$lang$Object == null ? (class$java$lang$Object = ArrayType.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(arrayType = type.getTypeClass())) break block10;
                                        Object[] objects = (Object[])values;
                                        int n = objects.length;
                                        for (int i = 0; i < n; ++i) {
                                            this.writeValue(objects[i], writer, context, type, name, ns);
                                        }
                                        break block11;
                                    }
                                    if (!Integer.TYPE.equals(arrayType)) break block12;
                                    int[] objects = (int[])values;
                                    int n = objects.length;
                                    for (int i = 0; i < n; ++i) {
                                        this.writeValue(new Integer(objects[i]), writer, context, type, name, ns);
                                    }
                                    break block11;
                                }
                                if (!Long.TYPE.equals(arrayType)) break block13;
                                long[] objects = (long[])values;
                                int n = objects.length;
                                for (int i = 0; i < n; ++i) {
                                    this.writeValue(new Long(objects[i]), writer, context, type, name, ns);
                                }
                                break block11;
                            }
                            if (!Short.TYPE.equals(arrayType)) break block14;
                            short[] objects = (short[])values;
                            int n = objects.length;
                            for (int i = 0; i < n; ++i) {
                                this.writeValue(new Short(objects[i]), writer, context, type, name, ns);
                            }
                            break block11;
                        }
                        if (!Double.TYPE.equals(arrayType)) break block15;
                        double[] objects = (double[])values;
                        int n = objects.length;
                        for (int i = 0; i < n; ++i) {
                            this.writeValue(new Double(objects[i]), writer, context, type, name, ns);
                        }
                        break block11;
                    }
                    if (!Float.TYPE.equals(arrayType)) break block16;
                    float[] objects = (float[])values;
                    int n = objects.length;
                    for (int i = 0; i < n; ++i) {
                        this.writeValue(new Float(objects[i]), writer, context, type, name, ns);
                    }
                    break block11;
                }
                if (!Byte.TYPE.equals(arrayType)) break block17;
                byte[] objects = (byte[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(new Byte(objects[i]), writer, context, type, name, ns);
                }
                break block11;
            }
            if (!Boolean.TYPE.equals(arrayType)) break block11;
            boolean[] objects = (boolean[])values;
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                this.writeValue(new Boolean(objects[i]), writer, context, type, name, ns);
            }
        }
    }

    protected void writeValue(Object value, MessageWriter writer, MessageContext context, Type type, String name, String ns) throws XFireFault {
        MessageWriter cwriter = writer.getElementWriter(name, ns);
        type.writeObject(value, cwriter, context);
        cwriter.close();
    }

    public void writeSchema(Element root) {
        try {
            Element complex = new Element("xsd:complexType", "http://www.w3.org/2001/XMLSchema");
            complex.addAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
            root.appendChild((Node)complex);
            Element seq = new Element("xsd:sequence", "http://www.w3.org/2001/XMLSchema");
            complex.appendChild((Node)seq);
            Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
            seq.appendChild((Node)element);
            Type componentType = this.getComponentType();
            String prefix = NamespaceHelper.getUniquePrefix((Element)root.getParent(), componentType.getSchemaType().getNamespaceURI());
            String typeName = prefix + ":" + componentType.getSchemaType().getLocalPart();
            element.addAttribute(new Attribute("name", componentType.getSchemaType().getLocalPart()));
            element.addAttribute(new Attribute("type", typeName));
            if (componentType.isNillable()) {
                element.addAttribute(new Attribute("nillable", "true"));
            }
            element.addAttribute(new Attribute("minOccurs", "0"));
            element.addAttribute(new Attribute("maxOccurs", "unbounded"));
        }
        catch (IllegalArgumentException e) {
            throw new XFireRuntimeException("Illegal argument.", e);
        }
    }

    public boolean isComplex() {
        return true;
    }

    public QName getComponentName() {
        return this.componentName;
    }

    public void setComponentName(QName componentName) {
        this.componentName = componentName;
    }

    public Set getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getComponentType());
        return deps;
    }

    public Type getComponentType() {
        Type type;
        Class<?> compType = this.getTypeClass().getComponentType();
        if (this.componentName == null) {
            type = this.getTypeMapping().getType(compType);
        } else {
            type = this.getTypeMapping().getType(this.componentName);
            if (type == null) {
                logger.debug((Object)("Couldn't find array component type " + this.componentName + ". Creating one instead."));
            }
        }
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(compType);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

