/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;

public class BeanTypeInfo {
    private Map qname2name = new HashMap();
    private Class typeClass;
    private List attributes = new ArrayList();
    private List elements = new ArrayList();
    private String defaultNamespace;
    private PropertyDescriptor[] descriptors;
    private TypeMapping typeMapping;
    private boolean initialized;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanTypeInfo(Class typeClass, String defaultNamespace) {
        this.typeClass = typeClass;
        this.defaultNamespace = defaultNamespace;
        this.initializeProperties();
    }

    public BeanTypeInfo(Class typeClass, String defaultNamespace, boolean initialize) {
        this.typeClass = typeClass;
        this.defaultNamespace = defaultNamespace;
        this.initializeProperties();
        this.setInitialized(!initialize);
    }

    protected BeanTypeInfo(Class typeClass) {
        this.typeClass = typeClass;
        this.initializeProperties();
    }

    public void initialize() {
        try {
            for (int i = 0; i < this.descriptors.length; ++i) {
                if (this.descriptors[i].getReadMethod() == null || this.descriptors[i].getWriteMethod() == null) continue;
                this.mapProperty(this.descriptors[i]);
            }
        }
        catch (Exception e) {
            if (e instanceof XFireRuntimeException) {
                throw (XFireRuntimeException)e;
            }
            throw new XFireRuntimeException("Couldn't create TypeInfo.", e);
        }
        this.setInitialized(true);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected void mapProperty(PropertyDescriptor pd) {
        String name = pd.getName();
        if (this.isAttribute(pd)) {
            this.mapAttribute(name, this.createQName(pd));
        } else if (this.isElement(pd)) {
            this.mapElement(name, this.createQName(pd));
        }
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!this.descriptors[i].getName().equals(name)) continue;
            return this.descriptors[i];
        }
        return null;
    }

    public Type getType(QName name) {
        Type type = this.getTypeMapping().getType(name);
        if (type == null) {
            PropertyDescriptor desc;
            try {
                desc = this.getPropertyDescriptor(name);
            }
            catch (Exception e) {
                if (e instanceof XFireRuntimeException) {
                    throw (XFireRuntimeException)e;
                }
                throw new XFireRuntimeException("Couldn't get properties.", e);
            }
            if (desc == null) {
                return null;
            }
            if (this.getTypeMapping().isRegistered(desc.getPropertyType()) && !(class$java$util$Collection == null ? (class$java$util$Collection = BeanTypeInfo.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(desc.getPropertyType())) {
                type = this.getTypeMapping().getType(desc.getPropertyType());
            } else {
                try {
                    type = this.getTypeMapping().getTypeCreator().createType(desc);
                }
                catch (XFireRuntimeException e) {
                    e.prepend("Couldn't create type for property " + desc.getName() + " on " + this.getTypeClass());
                    throw e;
                }
                this.getTypeMapping().register(type);
            }
        }
        if (type == null) {
            throw new XFireRuntimeException("Couldn't find type for property " + name);
        }
        return type;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    protected QName createQName(PropertyDescriptor desc) {
        return new QName(this.defaultNamespace, desc.getName());
    }

    public void mapAttribute(String property, QName type) {
        this.qname2name.put(type, property);
        this.attributes.add(type);
    }

    public void mapElement(String property, QName type) {
        this.qname2name.put(type, property);
        this.elements.add(type);
    }

    private void initializeProperties() {
        BeanInfo beanInfo = null;
        try {
            if (this.typeClass.isInterface() || this.typeClass.isPrimitive()) {
                beanInfo = Introspector.getBeanInfo(this.typeClass);
            } else if (this.typeClass != (class$java$lang$Object == null ? (class$java$lang$Object = BeanTypeInfo.class$("java.lang.Object")) : class$java$lang$Object)) {
                beanInfo = Introspector.getBeanInfo(this.typeClass, class$java$lang$Object == null ? (class$java$lang$Object = BeanTypeInfo.class$("java.lang.Object")) : class$java$lang$Object);
            }
        }
        catch (IntrospectionException e) {
            throw new XFireRuntimeException("Couldn't introspect interface.", e);
        }
        if (beanInfo != null) {
            this.descriptors = beanInfo.getPropertyDescriptors();
        }
        if (this.descriptors == null) {
            this.descriptors = new PropertyDescriptor[0];
        }
    }

    public PropertyDescriptor getPropertyDescriptor(QName name) {
        return this.getPropertyDescriptor(this.getPropertyName(name));
    }

    protected boolean isAttribute(PropertyDescriptor desc) {
        return false;
    }

    protected boolean isElement(PropertyDescriptor desc) {
        return true;
    }

    protected boolean isSerializable(PropertyDescriptor desc) {
        return true;
    }

    protected Class getTypeClass() {
        return this.typeClass;
    }

    public boolean isNillable(QName name) {
        return true;
    }

    private String getPropertyName(QName name) {
        return (String)this.qname2name.get(name);
    }

    public Iterator getAttributes() {
        return this.attributes.iterator();
    }

    public Iterator getElements() {
        return this.elements.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

