/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.type.AbstractTypeCreator;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.BeanType;
import org.codehaus.xfire.aegis.type.java5.AnnotatedTypeInfo;
import org.codehaus.xfire.aegis.type.java5.EnumType;
import org.codehaus.xfire.aegis.type.java5.XmlType;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.ServiceUtils;

public class Java5TypeCreator
extends AbstractTypeCreator {
    public AbstractTypeCreator.TypeClassInfo createClassInfo(Method m, int index) {
        AbstractTypeCreator.TypeClassInfo info;
        if (index >= 0) {
            AbstractTypeCreator.TypeClassInfo info2;
            java.lang.reflect.Type genericType = m.getGenericParameterTypes()[index];
            if (genericType instanceof Class) {
                info2 = this.nextCreator.createClassInfo(m, index);
            } else {
                info2 = new AbstractTypeCreator.TypeClassInfo();
                info2.setGenericType(genericType);
            }
            info2.setTypeClass(m.getParameterTypes()[index]);
            if (m.getParameterAnnotations()[index].length > 0) {
                info2.setAnnotations(m.getParameterAnnotations()[index]);
            }
            return info2;
        }
        java.lang.reflect.Type genericReturnType = m.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            info = this.nextCreator.createClassInfo(m, index);
        } else {
            info = new AbstractTypeCreator.TypeClassInfo();
            info.setGenericType(genericReturnType);
        }
        info.setTypeClass(m.getReturnType());
        if (m.getAnnotations().length > 0) {
            info.setAnnotations(m.getAnnotations());
        }
        return info;
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        AbstractTypeCreator.TypeClassInfo info = this.createBasicClassInfo(pd.getPropertyType());
        info.setGenericType(pd.getReadMethod().getGenericReturnType());
        info.setAnnotations(pd.getReadMethod().getAnnotations());
        return info;
    }

    public Type createCollectionType(AbstractTypeCreator.TypeClassInfo info) {
        ParameterizedType type;
        Object genericType = info.getGenericType();
        Class paramClass = Object.class;
        if (genericType instanceof ParameterizedType && (type = (ParameterizedType)genericType).getActualTypeArguments()[0] instanceof Class) {
            paramClass = (Class)type.getActualTypeArguments()[0];
        }
        return super.createCollectionType(info, paramClass);
    }

    public Type createDefaultType(AbstractTypeCreator.TypeClassInfo info) {
        BeanType type = new BeanType(new AnnotatedTypeInfo(this.getTypeMapping(), info.getTypeClass()));
        type.setTypeMapping(this.getTypeMapping());
        type.setSchemaType(this.createQName(info.getTypeClass()));
        return type;
    }

    public Type createEnumType(AbstractTypeCreator.TypeClassInfo info) {
        EnumType type = new EnumType();
        type.setSchemaType(this.createQName(info.getTypeClass()));
        type.setTypeClass(info.getTypeClass());
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    public QName createQName(Class typeClass) {
        String name = null;
        String ns = null;
        XmlType xtype = typeClass.getAnnotation(XmlType.class);
        if (xtype != null) {
            name = xtype.name();
            ns = xtype.namespace();
        }
        String clsName = typeClass.getName();
        if (name == null || name.length() == 0) {
            name = ServiceUtils.makeServiceNameFromClassName(typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = NamespaceHelper.makeNamespaceFromClassName(clsName, "http");
        }
        return new QName(ns, name);
    }

    protected boolean isEnum(Class javaType) {
        return javaType.isEnum();
    }
}

