/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.fault;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.util.DepthXMLStreamReader;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;
import org.codehaus.yom.stax.StaxBuilder;
import org.codehaus.yom.stax.StaxSerializer;

public class Soap12FaultSerializer
implements MessageSerializer {
    private StaxBuilder builder = new StaxBuilder();

    public void readMessage(InMessage message, MessageContext context) throws XFireFault {
        XFireFault fault = new XFireFault();
        DepthXMLStreamReader reader = new DepthXMLStreamReader(message.getXMLStreamReader());
        try {
            boolean end = false;
            while (!end && reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 7: {
                        String encoding = reader.getCharacterEncodingScheme();
                        message.setEncoding(encoding);
                        break;
                    }
                    case 8: {
                        end = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        if (reader.getLocalName().equals("Code")) {
                            reader.next();
                            STAXUtils.toNextElement(reader);
                            if (!reader.getLocalName().equals("Value")) break;
                            fault.setFaultCode(Soap12FaultSerializer.parseFaultCode(reader, reader.getElementText()));
                            break;
                        }
                        if (reader.getLocalName().equals("SubCode")) {
                            reader.next();
                            STAXUtils.toNextElement(reader);
                            if (!reader.getLocalName().equals("Value")) break;
                            fault.setSubCode(reader.getElementText());
                            break;
                        }
                        if (reader.getLocalName().equals("Reason")) {
                            reader.next();
                            STAXUtils.toNextElement(reader);
                            if (!reader.getLocalName().equals("Text")) break;
                            fault.setMessage(reader.getElementText());
                            break;
                        }
                        if (reader.getLocalName().equals("Actor")) {
                            fault.setRole(reader.getElementText());
                            break;
                        }
                        if (!reader.getLocalName().equals("Detail")) break;
                        fault.setDetail(this.builder.buildElement(null, (XMLStreamReader)reader));
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not parse message.", e, "Sender");
        }
        message.setBody(fault);
    }

    protected static String parseFaultCode(XMLStreamReader reader, String value) {
        int colon = value.indexOf(":");
        if (colon > -1) {
            String prefix = value.substring(0, colon);
            String local = value.substring(colon + 1);
            String uri = reader.getNamespaceURI(prefix);
            if (uri.equals(Soap12.getInstance().getNamespace())) {
                return local;
            }
            return value;
        }
        return value;
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        XFireFault fault = (XFireFault)message.getBody();
        try {
            Map namespaces = fault.getNamespaces();
            Iterator itr = namespaces.keySet().iterator();
            while (itr.hasNext()) {
                String prefix = (String)itr.next();
                writer.writeAttribute("xmlns:" + prefix, (String)namespaces.get(prefix));
            }
            writer.writeStartElement("soap:Fault");
            writer.writeStartElement("soap:Code");
            writer.writeStartElement("soap:Value");
            writer.writeCharacters("soap:" + fault.getFaultCode());
            writer.writeEndElement();
            if (fault.getSubCode() != null) {
                writer.writeStartElement("soap:SubCode");
                writer.writeStartElement("soap:Value");
                writer.writeCharacters(fault.getSubCode());
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeStartElement("soap:Reason");
            writer.writeStartElement("soap:Text");
            writer.writeCharacters(fault.getReason());
            writer.writeEndElement();
            writer.writeEndElement();
            if (fault.getRole() != null) {
                writer.writeStartElement("soap:Role");
                writer.writeCharacters(fault.getRole());
                writer.writeEndElement();
            }
            if (fault.hasDetails()) {
                Element detail = fault.getDetail();
                writer.writeStartElement("soap:Detail");
                StaxSerializer serializer = new StaxSerializer();
                Elements details = detail.getChildElements();
                for (int i = 0; i < details.size(); ++i) {
                    serializer.writeElement(details.get(i), writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException xe) {
            throw new XFireRuntimeException("Couldn't create fault.", xe);
        }
    }
}

