/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.loom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.codehaus.xfire.loom.ServiceDeployer;
import org.codehaus.xfire.loom.ServiceInvoker;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class DefaultServiceDeployer
extends AbstractLogEnabled
implements ServiceDeployer,
Serviceable,
Configurable {
    private final Map m_services = Collections.synchronizedMap(new HashMap());
    private ServiceRegistry m_serviceRegistry;
    private Map m_serviceFactories;
    private ServiceFactory m_defaultServiceFactory;
    private Map m_configurations;
    static /* synthetic */ Class class$org$codehaus$xfire$service$ServiceFactory;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] kids = configuration.getChildren("service");
        this.m_configurations = new HashMap(kids.length);
        for (int i = 0; i < kids.length; ++i) {
            this.m_configurations.put(kids[i].getAttribute("key"), kids[i]);
        }
        Configuration child = configuration.getChild("defaultFactory");
        this.m_defaultServiceFactory = (ServiceFactory)this.m_serviceFactories.get(child.getValue());
        if (null == this.m_defaultServiceFactory) {
            String msg = "Missing default factory '" + child.getValue() + "' at " + child.getLocation();
            throw new ConfigurationException(msg);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.m_serviceRegistry = (ServiceRegistry)manager.lookup(ServiceRegistry.ROLE);
        this.m_serviceFactories = (Map)manager.lookup((class$org$codehaus$xfire$service$ServiceFactory == null ? (class$org$codehaus$xfire$service$ServiceFactory = DefaultServiceDeployer.class$("org.codehaus.xfire.service.ServiceFactory")) : class$org$codehaus$xfire$service$ServiceFactory).getName() + "{}");
    }

    public void deploy(String key, Object object) throws Exception {
        Service endpoint;
        if (this.m_services.containsKey(key)) {
            throw new IllegalStateException("Service with key '" + key + "' already deployed");
        }
        Configuration configuration = (Configuration)this.m_configurations.get(key);
        if (null == configuration) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No configuration found for '" + key + "', using defaults");
            }
            endpoint = this.m_defaultServiceFactory.create(object.getClass());
        } else {
            endpoint = this.createServiceFromConfiguration(configuration);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Created '" + endpoint.getServiceInfo().getName() + "' from key '" + key + "'");
            }
        }
        endpoint.getBinding().setInvoker(new ServiceInvoker(object));
        this.registerService(key, endpoint);
    }

    private Service createServiceFromConfiguration(Configuration configuration) throws ConfigurationException {
        ServiceFactory factory = this.getServiceFactory(configuration.getChild("factory").getValue(null));
        String encodingUri = configuration.getChild("encodingStyleURI").getValue(null);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (encodingUri != null) {
            propertiesMap.put("type.mapping", encodingUri);
        }
        if (factory instanceof ObjectServiceFactory) {
            ObjectServiceFactory osf = (ObjectServiceFactory)factory;
            osf.setStyle(configuration.getChild("style").getValue("wrapped"));
            osf.setUse(configuration.getChild("use").getValue("wrapped"));
            osf.setSoapVersion(this.getSoapVersion(configuration.getChild("soapVersion")));
        }
        Configuration[] properties = configuration.getChildren("property");
        for (int i = 0; i < properties.length; ++i) {
            propertiesMap.put(properties[i].getAttribute("name"), properties[i].getAttribute("value"));
        }
        Service service = factory.create(this.loadClass(configuration.getChild("serviceClass")), configuration.getChild("name").getValue(), configuration.getChild("namespace").getValue(""), propertiesMap);
        return service;
    }

    private ServiceFactory getServiceFactory(String key) {
        if (this.m_serviceFactories.containsKey(key)) {
            return (ServiceFactory)this.m_serviceFactories.get(key);
        }
        return this.m_defaultServiceFactory;
    }

    private SoapVersion getSoapVersion(Configuration configuration) throws ConfigurationException {
        String value = configuration.getValue("1.1");
        if (value.equals("1.1")) {
            return Soap11.getInstance();
        }
        if (value.equals("1.2")) {
            return Soap12.getInstance();
        }
        String msg = "Invalid soap version at " + configuration.getLocation() + ". Must be 1.1 or 1.2.";
        throw new ConfigurationException(msg);
    }

    private Class loadClass(Configuration configuration) throws ConfigurationException {
        try {
            return ClassLoaderUtils.loadClass(configuration.getValue(), this.getClass());
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to load " + configuration.getValue() + " at " + configuration.getLocation();
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    private void registerService(String key, Service endpoint) {
        this.m_serviceRegistry.register(endpoint);
        this.m_services.put(key, endpoint.getName());
    }

    public void undeploy(String key) {
        if (this.m_services.containsKey(key)) {
            this.m_serviceRegistry.unregister((String)this.m_services.remove(key));
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Attempted to undeploy unknown key: " + key);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

