/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus.config;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.plexus.PlexusXFireComponent;
import org.codehaus.xfire.plexus.ServiceInvoker;
import org.codehaus.xfire.plexus.config.Configurator;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectBinding;
import org.codehaus.xfire.service.binding.ObjectInvoker;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class ObjectServiceConfigurator
extends PlexusXFireComponent
implements Configurator {
    static /* synthetic */ Class class$org$codehaus$xfire$transport$TransportManager;
    static /* synthetic */ Class class$java$lang$Class;

    public Service createService(PlexusConfiguration config) throws Exception {
        ObjectServiceFactory builder = this.getServiceFactory(config);
        String name = config.getChild("name").getValue("");
        String namespace = config.getChild("namespace").getValue("");
        String use = config.getChild("use").getValue("literal");
        String style = config.getChild("style").getValue("wrapped");
        String serviceClass = config.getChild("serviceClass").getValue();
        String role = config.getChild("role").getValue(serviceClass);
        String soapVersion = config.getChild("soapVersion").getValue("1.1");
        String wsdlUrl = config.getChild("wsdl").getValue("");
        Service service = null;
        if (wsdlUrl.length() > 0) {
            try {
                TypeMapping tm = this.getTypeMappingRegistry().createTypeMapping(true);
                PlexusConfiguration[] types = config.getChild("types").getChildren("type");
                for (int i = 0; i < types.length; ++i) {
                    this.initializeType(types[i], tm);
                }
                URL url = null;
                try {
                    url = new URL(wsdlUrl);
                }
                catch (MalformedURLException e) {
                    url = new File(wsdlUrl).toURL();
                }
                service = builder.create(this.loadClass(serviceClass), url);
            }
            catch (WSDLException e) {
                throw new PlexusConfigurationException("Could not load the WSDL file.", (Throwable)e);
            }
        }
        Class<?> clazz = this.getClass().getClassLoader().loadClass(serviceClass);
        SoapVersion version = null;
        if (soapVersion.equals("1.1")) {
            version = Soap11.getInstance();
        } else if (soapVersion.equals("1.2")) {
            version = Soap12.getInstance();
        }
        builder.setStyle(style);
        builder.setUse(use);
        builder.setSoapVersion(version);
        service = name.length() == 0 && namespace.length() == 0 ? builder.create(clazz, (Map)null) : builder.create(clazz, name, namespace, null);
        PlexusConfiguration[] types = config.getChild("types").getChildren("type");
        for (int i = 0; i < types.length; ++i) {
            this.initializeType(types[i], AegisBindingProvider.getTypeMapping(service));
        }
        ObjectBinding binding = service.getBinding();
        if (this.getServiceLocator().hasComponent(role)) {
            ServiceInvoker invoker = new ServiceInvoker(role, this.getServiceLocator());
            binding.setInvoker(invoker);
        } else {
            ObjectInvoker oinvoker = new ObjectInvoker();
            String scope = config.getChild("scope").getValue("application");
            if (scope.equals("application")) {
                oinvoker.setScope(1);
            } else if (scope.equals("session")) {
                oinvoker.setScope(2);
            } else if (scope.equals("request")) {
                oinvoker.setScope(3);
            }
            String implClass = config.getChild("implementationClass").getValue("");
            if (implClass.length() > 0) {
                service.setProperty("xfire.serviceImplClass", this.loadClass(implClass));
            }
            binding.setInvoker(oinvoker);
        }
        if (service.getInHandlers() == null) {
            service.setInHandlers(new ArrayList());
        }
        if (service.getOutHandlers() == null) {
            service.setOutHandlers(new ArrayList());
        }
        if (service.getFaultHandlers() == null) {
            service.setFaultHandlers(new ArrayList());
        }
        this.createHandlers(config.getChild("inHandlers"), service.getInHandlers());
        this.createHandlers(config.getChild("outHandlers"), service.getOutHandlers());
        this.createHandlers(config.getChild("faultHandlers"), service.getFaultHandlers());
        this.getLogger().info("Registered service " + service.getName());
        this.getServiceRegistry().register(service);
        return service;
    }

    private void createHandlers(PlexusConfiguration child, List handlerList) throws Exception {
        if (child == null) {
            return;
        }
        PlexusConfiguration[] handlers = child.getChildren("handler");
        if (handlers.length == 0) {
            return;
        }
        for (int i = 0; i < handlers.length; ++i) {
            handlerList.add(this.getHandler(handlers[i].getValue()));
        }
    }

    public ObjectServiceFactory getServiceFactory(PlexusConfiguration config) throws Exception {
        String factoryClass = config.getChild("serviceFactory").getValue("");
        BindingProvider binding = this.getBindingProvider(config);
        return this.getServiceFactory(factoryClass, binding);
    }

    protected BindingProvider getBindingProvider(PlexusConfiguration config) throws InstantiationException, IllegalAccessException, Exception {
        String bindingClass = config.getChild("bindingProvider").getValue("");
        BindingProvider binding = null;
        binding = bindingClass.length() > 0 ? (BindingProvider)this.loadClass(bindingClass).newInstance() : new AegisBindingProvider(this.getTypeMappingRegistry());
        return binding;
    }

    protected ObjectServiceFactory getServiceFactory(String builderClass, BindingProvider bindingProvider) throws Exception {
        if (builderClass.length() == 0) {
            return new ObjectServiceFactory(this.getXFire().getTransportManager(), null);
        }
        Class clz = this.loadClass(builderClass);
        Constructor con = clz.getConstructor(class$org$codehaus$xfire$transport$TransportManager == null ? (class$org$codehaus$xfire$transport$TransportManager = ObjectServiceConfigurator.class$("org.codehaus.xfire.transport.TransportManager")) : class$org$codehaus$xfire$transport$TransportManager, class$java$lang$Class == null ? (class$java$lang$Class = ObjectServiceConfigurator.class$("java.lang.Class")) : class$java$lang$Class);
        return (ObjectServiceFactory)con.newInstance(this.getXFire().getTransportManager(), bindingProvider);
    }

    private void initializeType(PlexusConfiguration configuration, TypeMapping tm) throws Exception {
        try {
            String ns = configuration.getAttribute("namespace", tm.getEncodingStyleURI());
            String name = configuration.getAttribute("name");
            Type type = (Type)this.loadClass(configuration.getAttribute("type")).newInstance();
            tm.register(this.loadClass(configuration.getAttribute("class")), new QName(ns, name), type);
        }
        catch (Exception e) {
            if (e instanceof PlexusConfigurationException) {
                throw (PlexusConfigurationException)e;
            }
            throw new PlexusConfigurationException("Could not configure type.", (Throwable)e);
        }
    }

    protected Handler getHandler(String name) throws Exception {
        try {
            return (Handler)this.getServiceLocator().lookup(Handler.ROLE, name);
        }
        catch (ComponentLookupException e) {
            return (Handler)this.loadClass(name).newInstance();
        }
    }

    public XFire getXFire() {
        XFire xfire = null;
        try {
            xfire = (XFire)this.getServiceLocator().lookup(XFire.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Couldn't find the XFire engine!", e);
        }
        return xfire;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        TypeMappingRegistry registry = null;
        try {
            registry = (TypeMappingRegistry)this.getServiceLocator().lookup(TypeMappingRegistry.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Couldn't find the TypeMappingRegistry!", e);
        }
        return registry;
    }

    protected TransportManager getTransportManager() {
        TransportManager transMan = null;
        try {
            transMan = (TransportManager)this.getServiceLocator().lookup(TransportManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Couldn't find the TransportManager!", e);
        }
        return transMan;
    }

    protected Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return ClassLoaderUtils.loadClass(className, this.getClass());
    }

    protected ServiceRegistry getServiceRegistry() {
        ServiceRegistry registry = null;
        try {
            registry = (ServiceRegistry)this.getServiceLocator().lookup(ServiceRegistry.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Couldn't find the ServiceRegistry!", e);
        }
        return registry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

