/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.event.RegistrationEvent;
import org.codehaus.xfire.service.event.RegistrationEventListener;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private Map services = new HashMap();
    private List eventListeners = new ArrayList();

    public Service getService(String name) {
        return (Service)this.services.get(name);
    }

    public void register(Service endpoint) {
        this.services.put(endpoint.getName(), endpoint);
        Iterator iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            RegistrationEventListener listener = (RegistrationEventListener)iterator.next();
            RegistrationEvent event = new RegistrationEvent(this, endpoint);
            listener.endpointRegistered(event);
        }
    }

    public void unregister(String name) {
        Service endpoint = this.getService(name);
        Iterator iterator = this.eventListeners.iterator();
        while (iterator.hasNext()) {
            RegistrationEventListener listener = (RegistrationEventListener)iterator.next();
            RegistrationEvent event = new RegistrationEvent(this, endpoint);
            listener.endpointUnregistered(event);
        }
        this.services.remove(name);
    }

    public boolean hasService(String name) {
        return this.services.containsKey(name);
    }

    public Collection getServices() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    public void addRegistrationEventListener(RegistrationEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeRegistrationEventListener(RegistrationEventListener listener) {
        this.eventListeners.remove(listener);
    }
}

