/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.MessageHeaderInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.Invoker;
import org.codehaus.xfire.service.binding.ObjectBinding;

public abstract class AbstractBinding
extends AbstractHandler
implements ObjectBinding,
Cloneable {
    private static final Log logger = LogFactory.getLog((String)(class$org$codehaus$xfire$service$binding$AbstractBinding == null ? (class$org$codehaus$xfire$service$binding$AbstractBinding = AbstractBinding.class$("org.codehaus.xfire.service.binding.AbstractBinding")) : class$org$codehaus$xfire$service$binding$AbstractBinding).getName());
    public static final String OPERATION_KEY = "xfire.operation";
    public static final String RESPONSE_VALUE = "xfire.java.response";
    public static final String RESPONSE_PIPE = "xfire.java.responsePipe";
    private String style;
    private String use;
    private Invoker invoker;
    private BindingProvider bindingProvider;
    private boolean clientModeOn = false;
    static /* synthetic */ Class class$org$codehaus$xfire$service$binding$AbstractBinding;

    public String getPhase() {
        return "service";
    }

    public void setOperation(OperationInfo operation, MessageContext context) {
        MessageExchange exchange = context.createMessageExchange(operation);
        context.setExchange(exchange);
    }

    public void invoke(final MessageContext context) throws Exception {
        try {
            final List params = (List)context.getInMessage().getBody();
            final OperationInfo operation = context.getExchange().getOperation();
            List headerInfos = operation.getInputMessage().getMessageHeaders();
            Iterator itr = headerInfos.iterator();
            while (itr.hasNext()) {
                MessageHeaderInfo header = (MessageHeaderInfo)itr.next();
                BindingProvider provider = context.getService().getBinding().getBindingProvider();
                params.add(header.getIndex(), provider.readHeader(header, context));
            }
            final Invoker invoker = this.getInvoker();
            if (!operation.isAsync()) {
                this.sendMessage(context, params, operation, invoker);
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            AbstractBinding.this.sendMessage(context, params, operation, invoker);
                        }
                        catch (Exception e) {
                            XFireFault fault = XFireFault.createFault(e);
                            context.getInPipeline().handleFault(fault, context);
                        }
                    }
                };
                Thread opthread = new Thread(runnable);
                opthread.start();
            }
        }
        catch (XFireRuntimeException e) {
            logger.warn((Object)"Error invoking service.", (Throwable)e);
            throw new XFireFault("Error invoking service.", e, "Sender");
        }
    }

    protected void sendMessage(MessageContext context, List params, OperationInfo operation, Invoker invoker) throws Exception {
        Object value = invoker.invoke(operation.getMethod(), params.toArray(), context);
        if (context.getExchange().hasOutMessage()) {
            OutMessage outMsg = context.getExchange().getOutMessage();
            outMsg.setBody(new Object[]{value});
            outMsg.setSerializer(context.getService().getBinding());
            context.getOutPipeline().invoke(context);
        }
    }

    protected void nextEvent(XMLStreamReader dr) {
        try {
            dr.next();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public String getStyle() {
        return this.style;
    }

    protected void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    protected void setUse(String use) {
        this.use = use;
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public boolean isClientModeOn() {
        return this.clientModeOn;
    }

    public void setClientModeOn(boolean clientModeOn) {
        this.clientModeOn = clientModeOn;
    }

    public abstract Object clone();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

