/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.FaultSender;
import org.codehaus.xfire.fault.Soap11FaultSerializer;
import org.codehaus.xfire.fault.Soap12FaultSerializer;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectBinding;
import org.codehaus.xfire.service.binding.ObjectBindingFactory;
import org.codehaus.xfire.service.binding.ObjectInvoker;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.ServiceUtils;
import org.codehaus.xfire.wsdl.ResourceWSDL;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.builder.DefaultWSDLBuilderFactory;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderAdapter;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilderFactory;

public class ObjectServiceFactory
implements ServiceFactory {
    private BindingProvider bindingProvider;
    private TransportManager transportManager;
    private String style;
    private String use;
    private Set ignoredClasses = new HashSet();
    private SoapVersion soapVersion = Soap11.getInstance();
    private boolean voidOneWay;
    private WSDLBuilderFactory wsdlBuilderFactory = new DefaultWSDLBuilderFactory();
    static /* synthetic */ Class class$org$codehaus$xfire$MessageContext;

    public ObjectServiceFactory() {
        this.setStyle("wrapped");
        this.setUse("literal");
        this.ignoredClasses.add("java.lang.Object");
        this.ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        this.ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        this.ignoredClasses.add("javax.ejb.EJBObject");
        this.ignoredClasses.add("javax.rmi.CORBA.Stub");
    }

    public ObjectServiceFactory(TransportManager transportManager, BindingProvider provider) {
        this();
        this.bindingProvider = provider;
        this.transportManager = transportManager;
    }

    public ObjectServiceFactory(TransportManager transportManager) {
        this();
        this.transportManager = transportManager;
    }

    public BindingProvider getBindingProvider() {
        if (this.bindingProvider == null) {
            try {
                this.bindingProvider = (BindingProvider)ClassLoaderUtils.loadClass("org.codehaus.xfire.aegis.AegisBindingProvider", this.getClass()).newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't find a binding provider!", e);
            }
        }
        return this.bindingProvider;
    }

    public Service create(Class clazz, URL wsdlUrl) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.readWSDL(wsdlUrl.toString());
        QName name = ServiceUtils.makeQualifiedNameFromClass(clazz);
        ServiceInfo serviceInfo = new ServiceInfo(name, clazz);
        Service endpoint = new Service(serviceInfo);
        endpoint.setWSDLWriter(new ResourceWSDL(wsdlUrl));
        throw new UnsupportedOperationException("create() isn't working yet.");
    }

    public Service create(Class clazz) {
        return this.create(clazz, (Map)null);
    }

    public Service create(Class clazz, Map properties) {
        return this.create(clazz, null, null, properties);
    }

    public Service create(Class clazz, String name, String namespace, Map properties) {
        return this.create(clazz, name, namespace, null, null, null, properties);
    }

    protected String makeServiceNameFromClassName(Class clazz) {
        return ServiceUtils.makeServiceNameFromClassName(clazz);
    }

    public Service create(Class clazz, String name, String namespace, SoapVersion version, String style, String use, Map properties) {
        String theName = name != null ? name : this.makeServiceNameFromClassName(clazz);
        String theNamespace = namespace != null ? namespace : NamespaceHelper.makeNamespaceFromClassName(clazz.getName(), "http");
        QName qName = new QName(theNamespace, theName);
        SoapVersion theVersion = version != null ? version : this.soapVersion;
        String theStyle = style != null ? style : this.style;
        String theUse = use != null ? use : this.use;
        ServiceInfo serviceInfo = new ServiceInfo(qName, clazz);
        Service endpoint = new Service(serviceInfo);
        this.setProperties(endpoint, properties);
        endpoint.setSoapVersion(theVersion);
        ObjectBinding binding = ObjectBindingFactory.getMessageBinding(theStyle, theUse);
        binding.setInvoker(new ObjectInvoker());
        endpoint.setBinding(binding);
        if (theVersion instanceof Soap11) {
            endpoint.setFaultSerializer(new Soap11FaultSerializer());
        } else {
            endpoint.setFaultSerializer(new Soap12FaultSerializer());
        }
        if (this.transportManager != null && binding instanceof WSDL11ParameterBinding) {
            endpoint.setWSDLWriter(new WSDLBuilderAdapter(this.getWsdlBuilderFactory(), endpoint, this.transportManager, (WSDL11ParameterBinding)((Object)binding)));
        }
        this.initializeOperations(endpoint);
        try {
            BindingProvider provider = this.getBindingProvider();
            provider.initialize(endpoint);
            binding.setBindingProvider(provider);
        }
        catch (Exception e) {
            if (e instanceof XFireRuntimeException) {
                throw (XFireRuntimeException)e;
            }
            throw new XFireRuntimeException("Couldn't load provider.", e);
        }
        this.registerHandlers(endpoint);
        return endpoint;
    }

    protected void registerHandlers(Service service) {
        service.addOutHandler(new OutMessageSender());
        service.addInHandler(service.getBinding());
        service.addFaultHandler(new FaultSender());
    }

    private void setProperties(Service service, Map properties) {
        if (properties == null) {
            return;
        }
        Iterator itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            service.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    protected void initializeOperations(Service endpoint) {
        Method[] methods = endpoint.getServiceInfo().getServiceClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!this.isValidMethod(method)) continue;
            this.addOperation(endpoint, method);
        }
    }

    public void addIgnoredMethods(String className) {
        this.ignoredClasses.add(className);
    }

    protected boolean isValidMethod(Method method) {
        if (this.ignoredClasses.contains(method.getDeclaringClass().getName())) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    protected void addOperation(Service endpoint, Method method) {
        ServiceInfo service = endpoint.getServiceInfo();
        AbstractBinding binding = (AbstractBinding)endpoint.getBinding();
        String opName = this.getOperationName(service, method);
        OperationInfo op = service.addOperation(opName, method);
        op.setAction(this.getAction(op));
        Class<?>[] paramClasses = method.getParameterTypes();
        boolean isDoc = binding.getStyle().equals("document");
        MessageInfo inMsg = op.createMessage(new QName(op.getName() + "Request"));
        op.setInputMessage(inMsg);
        for (int j = 0; j < paramClasses.length; ++j) {
            QName q;
            if (this.isHeader(method, j)) {
                q = this.getInParameterName(endpoint, method, j, isDoc);
                inMsg.addMessageHeader(q, paramClasses[j]).setIndex(j);
                continue;
            }
            if (paramClasses[j].equals(class$org$codehaus$xfire$MessageContext == null ? ObjectServiceFactory.class$("org.codehaus.xfire.MessageContext") : class$org$codehaus$xfire$MessageContext)) continue;
            q = this.getInParameterName(endpoint, method, j, isDoc);
            inMsg.addMessagePart(q, paramClasses[j]).setIndex(j);
        }
        MessageInfo outMsg = op.createMessage(new QName(op.getName() + "Response"));
        op.setOutputMessage(outMsg);
        Class<Void> returnType = method.getReturnType();
        if (!returnType.isAssignableFrom(Void.TYPE)) {
            if (this.isHeader(method, -1)) {
                QName q = this.getOutParameterName(endpoint, method, isDoc);
                outMsg.addMessageHeader(q, method.getReturnType()).setIndex(0);
            } else {
                QName q = this.getOutParameterName(endpoint, method, isDoc);
                outMsg.addMessagePart(q, method.getReturnType());
            }
        }
        op.setMEP(this.getMEP(method));
        op.setAsync(this.isAsync(method));
    }

    protected String getAction(OperationInfo op) {
        return "";
    }

    protected boolean isHeader(Method method, int j) {
        return false;
    }

    protected String getOperationName(ServiceInfo service, Method method) {
        if (service.getOperation(method.getName()) == null) {
            return method.getName();
        }
        int i = 1;
        String name;
        while (service.getOperation(name = method.getName() + i) != null) {
            ++i;
        }
        return name;
    }

    protected String getMEP(Method method) {
        if (this.isVoidOneWay() && method.getReturnType().equals(Void.TYPE)) {
            return "urn:xfire:mep:in";
        }
        return "urn:xfire:mep:in-out";
    }

    protected boolean isAsync(Method method) {
        return false;
    }

    protected QName getInParameterName(Service endpoint, Method method, int paramNumber, boolean doc) {
        String paramName = "";
        if (doc) {
            paramName = method.getName();
        }
        return new QName(endpoint.getServiceInfo().getName().getNamespaceURI(), paramName + "in" + paramNumber);
    }

    protected QName getOutParameterName(Service endpoint, Method method, boolean doc) {
        String outName = "";
        if (doc) {
            outName = method.getName();
        }
        return new QName(endpoint.getServiceInfo().getName().getNamespaceURI(), outName + "out");
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public boolean isVoidOneWay() {
        return this.voidOneWay;
    }

    public void setVoidOneWay(boolean voidOneWay) {
        this.voidOneWay = voidOneWay;
    }

    public WSDLBuilderFactory getWsdlBuilderFactory() {
        return this.wsdlBuilderFactory;
    }

    public void setWsdlBuilderFactory(WSDLBuilderFactory wsdlBuilderFactory) {
        this.wsdlBuilderFactory = wsdlBuilderFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

