/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.DepthXMLStreamReader;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class WrappedBinding
extends AbstractBinding
implements WSDL11ParameterBinding,
MessageSerializer {
    public WrappedBinding() {
        this.setStyle("wrapped");
        this.setUse("literal");
    }

    public void readMessage(InMessage inMessage, MessageContext context) throws XFireFault {
        OperationInfo op;
        Service endpoint = context.getService();
        ArrayList<Object> parameters = new ArrayList<Object>();
        DepthXMLStreamReader dr = new DepthXMLStreamReader(context.getInMessage().getXMLStreamReader());
        if (!STAXUtils.toNextElement(dr)) {
            throw new XFireFault("There must be a method name element.", "Sender");
        }
        MessageInfo msgInfo = null;
        if (this.isClientModeOn()) {
            op = context.getExchange().getOperation();
            msgInfo = op.getOutputMessage();
        } else {
            if (context.getExchange().getOperation() == null) {
                op = endpoint.getServiceInfo().getOperation(dr.getLocalName());
                if (op == null) {
                    throw new XFireFault("Invalid operation: " + dr.getName(), "Sender");
                }
                this.setOperation(op, context);
            }
            msgInfo = context.getExchange().getOperation().getInputMessage();
        }
        this.nextEvent(dr);
        while (STAXUtils.toNextElement(dr)) {
            MessagePartInfo p = msgInfo.getMessagePart(dr.getName());
            if (p == null) {
                throw new XFireFault("Parameter " + dr.getName() + " does not exist!", "Sender");
            }
            parameters.add(this.getBindingProvider().readParameter(p, inMessage.getXMLStreamReader(), context));
        }
        inMessage.setBody(parameters);
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        try {
            Service endpoint = context.getService();
            Object[] values = (Object[])message.getBody();
            OperationInfo op = context.getExchange().getOperation();
            String name = null;
            MessageInfo msgInfo = null;
            if (this.isClientModeOn()) {
                name = op.getName();
                msgInfo = op.getInputMessage();
            } else {
                name = op.getName() + "Response";
                msgInfo = op.getOutputMessage();
            }
            this.writeStartElement(writer, name, endpoint.getServiceInfo().getName().getNamespaceURI());
            int i = 0;
            Iterator itr = msgInfo.getMessageParts().iterator();
            while (itr.hasNext()) {
                MessagePartInfo outParam = (MessagePartInfo)itr.next();
                this.getBindingProvider().writeParameter(outParam, writer, context, values[i]);
                ++i;
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't write start element.", e);
        }
    }

    public void writeStartElement(XMLStreamWriter writer, String name, String namespace) throws XMLStreamException {
        String prefix = "";
        writer.setPrefix(prefix, namespace);
        writer.writeStartElement(prefix, name, namespace);
        writer.writeNamespace(prefix, namespace);
    }

    public void createInputParts(WSDLBuilder builder, Message req, OperationInfo op) {
        Part part = builder.getDefinition().createPart();
        QName typeQName = this.createDocumentType(builder, op.getInputMessage(), part, op.getName());
        part.setName("parameters");
        part.setElementName(typeQName);
        req.addPart(part);
    }

    public void createOutputParts(WSDLBuilder builder, Message req, OperationInfo op) {
        Part part = builder.getDefinition().createPart();
        QName typeQName = this.createDocumentType(builder, op.getOutputMessage(), part, op.getName() + "Response");
        part.setElementName(typeQName);
        part.setName("parameters");
        req.addPart(part);
    }

    private QName createDocumentType(WSDLBuilder builder, MessageInfo message, Part part, String opName) {
        Element schemaEl = builder.createSchemaType(builder.getInfo().getTargetNamespace());
        Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
        schemaEl.appendChild((Node)element);
        element.addAttribute(new Attribute("name", opName));
        Element complex = new Element("xsd:complexType", "http://www.w3.org/2001/XMLSchema");
        element.appendChild((Node)complex);
        if (message.getMessageParts().size() > 0) {
            Element sequence = this.createSequence(complex);
            this.writeParametersSchema(builder, message.getMessageParts(), sequence);
        }
        return new QName(builder.getInfo().getTargetNamespace(), opName);
    }

    private void writeParametersSchema(WSDLBuilder builder, Collection params, Element sequence) {
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            MessagePartInfo param = (MessagePartInfo)itr.next();
            QName pName = param.getName();
            SchemaType type = param.getSchemaType();
            builder.addDependency(type);
            QName schemaType = type.getSchemaType();
            builder.addNamespaceImport(builder.getService().getServiceInfo().getName().getNamespaceURI(), schemaType.getNamespaceURI());
            String uri = type.getSchemaType().getNamespaceURI();
            String prefix = builder.getNamespacePrefix(uri);
            builder.addNamespace(prefix, uri);
            Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
            sequence.appendChild((Node)element);
            if (type.isAbstract()) {
                element.addAttribute(new Attribute("name", pName.getLocalPart()));
                element.addAttribute(new Attribute("type", prefix + ":" + schemaType.getLocalPart()));
            } else {
                element.addAttribute(new Attribute("ref", prefix + ":" + schemaType.getLocalPart()));
            }
            element.addAttribute(new Attribute("minOccurs", "1"));
            element.addAttribute(new Attribute("maxOccurs", "1"));
        }
    }

    private Element createSequence(Element complex) {
        Element sequence = new Element("xsd:sequence", "http://www.w3.org/2001/XMLSchema");
        complex.appendChild((Node)sequence);
        return sequence;
    }

    public Object clone() {
        WrappedBinding binding = new WrappedBinding();
        binding.setBindingProvider(this.getBindingProvider());
        return binding;
    }
}

