/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.soap.handler;

import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;

public class ValidateHeadersHandler
extends AbstractHandler {
    public String getPhase() {
        return "pre-invoke";
    }

    public void invoke(MessageContext context) throws Exception {
        if (context.getInMessage().getHeader() == null) {
            return;
        }
        SoapVersion version = context.getInMessage().getSoapVersion();
        Elements elements = context.getInMessage().getHeader().getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            Element e = elements.get(i);
            String mustUnderstand = e.getAttributeValue("mustUnderstand", version.getNamespace());
            if (mustUnderstand == null || !mustUnderstand.equals("1")) continue;
            this.assertUnderstandsHeader(context, new QName(e.getNamespaceURI(), e.getLocalName()));
        }
    }

    protected void assertUnderstandsHeader(MessageContext context, QName name) throws XFireFault {
        if (context.getInPipeline().understands(name)) {
            return;
        }
        if (context.getOutPipeline().understands(name)) {
            return;
        }
        throw new XFireFault("Header {" + name.getLocalPart() + "}" + name.getNamespaceURI() + " was not undertsood by the service.", "MustUnderstand");
    }
}

