/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.yom.Node;
import org.codehaus.yom.xpath.YOMXPath;
import org.jaxen.XPath;

public class XPathAssert {
    public static List assertValid(String xpath, Node node, Map namespaces) throws Exception {
        List nodes = XPathAssert.createXPath(xpath, namespaces).selectNodes((Object)node);
        if (nodes.size() == 0) {
            throw new AssertionFailedError("Failed to select any nodes for expression:.\n" + xpath + "\n" + node.toXML());
        }
        return nodes;
    }

    public static List assertInvalid(String xpath, Node node, Map namespaces) throws Exception {
        List nodes = XPathAssert.createXPath(xpath, namespaces).selectNodes((Object)node);
        if (nodes.size() > 0) {
            throw new AssertionFailedError("Found multiple nodes for expression:\n" + xpath + "\n" + node.toXML());
        }
        return nodes;
    }

    public static void assertXPathEquals(String xpath, String value, Node node, Map namespaces) throws Exception {
        String value2 = ((Node)XPathAssert.createXPath(xpath, namespaces).selectSingleNode((Object)node)).getValue().trim();
        Assert.assertEquals((String)value, (String)value2);
    }

    public static void assertNoFault(Node node) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", Soap11.getInstance().getNamespace());
        namespaces.put("s12", Soap12.getInstance().getNamespace());
        XPathAssert.assertInvalid("/s:Envelope/s:Body/s:Fault", node, namespaces);
        XPathAssert.assertInvalid("/s12:Envelope/s12:Body/s12:Fault", node, namespaces);
    }

    public static void assertFault(Node node) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("s", Soap11.getInstance().getNamespace());
        namespaces.put("s12", Soap12.getInstance().getNamespace());
        XPathAssert.assertValid("/s:Envelope/s:Body/s:Fault", node, namespaces);
        XPathAssert.assertValid("/s12:Envelope/s12:Body/s12:Fault", node, namespaces);
    }

    public static XPath createXPath(String xpathString, Map namespaces) throws Exception {
        YOMXPath xpath = new YOMXPath(xpathString);
        Iterator itr = namespaces.keySet().iterator();
        while (itr.hasNext()) {
            String ns = (String)itr.next();
            xpath.addNamespace(ns, (String)namespaces.get(ns));
        }
        return xpath;
    }
}

