/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.event.RegistrationEvent;
import org.codehaus.xfire.service.event.RegistrationEventListener;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.dead.DeadLetterTransport;
import org.codehaus.xfire.transport.local.LocalTransport;

public class DefaultTransportManager
implements TransportManager,
RegistrationEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$DefaultTransportManager == null ? (class$org$codehaus$xfire$transport$DefaultTransportManager = DefaultTransportManager.class$("org.codehaus.xfire.transport.DefaultTransportManager")) : class$org$codehaus$xfire$transport$DefaultTransportManager));
    private Map services = new HashMap();
    private Map transports = new HashMap();
    private Map transportUris = new HashMap();
    private ServiceRegistry serviceRegistry;
    static /* synthetic */ Class class$org$codehaus$xfire$transport$DefaultTransportManager;

    public DefaultTransportManager() {
    }

    public DefaultTransportManager(ServiceRegistry registry) {
        this.serviceRegistry = registry;
        this.initialize();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void initialize() {
        this.initializeTransports();
        this.register(SoapTransport.createSoapTransport(new LocalTransport()));
        this.register(SoapTransport.createSoapTransport(new DeadLetterTransport()));
    }

    protected void initializeTransports() {
        Iterator itr = this.serviceRegistry.getServices().iterator();
        while (itr.hasNext()) {
            Service endpoint = (Service)itr.next();
            this.enableAll(endpoint.getName());
        }
        this.serviceRegistry.addRegistrationEventListener(this);
    }

    public void register(Transport transport) {
        this.transports.put(transport.getName(), transport);
        String[] schemes = transport.getKnownUriSchemes();
        for (int i = 0; i < schemes.length; ++i) {
            this.transportUris.put(schemes[i], transport);
        }
        Iterator itr = this.services.values().iterator();
        while (itr.hasNext()) {
            Map serviceTransports = (Map)itr.next();
            serviceTransports.put(transport.getName(), transport);
        }
        log.debug((Object)("Registered transport " + transport.getName()));
    }

    public void unregister(Transport transport) {
        this.transports.remove(transport);
        Iterator itr = this.services.values().iterator();
        while (itr.hasNext()) {
            Map serviceTransports = (Map)itr.next();
            if (serviceTransports == null) continue;
            serviceTransports.remove(transport);
        }
    }

    public Transport getTransport(String name) {
        return (Transport)this.transports.get(name);
    }

    public void enable(String transport, String serviceName) {
        HashMap<String, Transport> serviceTransports = (HashMap<String, Transport>)this.services.get(serviceName);
        if (serviceTransports == null) {
            serviceTransports = new HashMap<String, Transport>();
            this.services.put(serviceName, serviceTransports);
        }
        serviceTransports.put(transport, this.getTransport(transport));
    }

    public void disable(String transport, String serviceName) {
        Map serviceTransports = (Map)this.services.get(serviceName);
        if (serviceTransports == null) {
            return;
        }
        serviceTransports.remove(transport);
    }

    public Collection getTransports(String service) {
        Map transports = (Map)this.services.get(service);
        if (transports != null) {
            return transports.values();
        }
        return null;
    }

    public Collection getTransports() {
        return this.transports.values();
    }

    public void enableAll(String serviceName) {
        HashMap<String, Transport> serviceTransports = (HashMap<String, Transport>)this.services.get(serviceName);
        if (serviceTransports == null) {
            serviceTransports = new HashMap<String, Transport>();
            this.services.put(serviceName, serviceTransports);
        }
        Iterator itr = this.transports.values().iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            serviceTransports.put(t.getName(), t);
        }
    }

    public void disableAll(String serviceName) {
        Map serviceTransports = (Map)this.services.get(serviceName);
        if (serviceTransports == null) {
            return;
        }
        Iterator itr = this.transports.keySet().iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            serviceTransports.remove(name);
        }
    }

    public boolean isEnabled(String service, String transportName) {
        Map serviceTransports = (Map)this.services.get(service);
        if (serviceTransports == null) {
            return false;
        }
        return serviceTransports.containsKey(transportName);
    }

    public void endpointRegistered(RegistrationEvent event) {
        this.enableAll(event.getEndpoint().getName());
    }

    public void endpointUnregistered(RegistrationEvent event) {
        this.disableAll(event.getEndpoint().getName());
    }

    public Transport getTransportForUri(String uri) {
        Iterator itr = this.transportUris.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (!uri.startsWith((String)entry.getKey())) continue;
            return (Transport)entry.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

