/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.util.DOMUtils;
import org.codehaus.xfire.util.DepthXMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STAXUtils {
    public static boolean skipToStartOfElement(XMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static boolean toNextElement(DepthXMLStreamReader dr) {
        if (dr.getEventType() == 1) {
            return true;
        }
        if (dr.getEventType() == 2) {
            return false;
        }
        try {
            int depth = dr.getDepth();
            int event = dr.getEventType();
            while (dr.getDepth() >= depth) {
                if (event == 1 && dr.getDepth() == depth + 1) {
                    return true;
                }
                if (event == 2) {
                    --depth;
                }
                event = dr.next();
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public static boolean skipToStartOfElement(DepthXMLStreamReader in) throws XMLStreamException {
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                return true;
            }
            code = in.next();
        }
        return false;
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    STAXUtils.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0) break;
                    return;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        String local = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String boundPrefix = writer.getPrefix(uri);
        boolean writeElementNS = false;
        if (boundPrefix == null || !prefix.equals(boundPrefix)) {
            writeElementNS = true;
        }
        if (uri != null && prefix.length() > 0) {
            writer.writeStartElement(prefix, local, uri);
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    public static void writeElement(Element e, XMLStreamWriter writer) throws XMLStreamException {
        String curUri;
        String prefix = e.getPrefix();
        String ns = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (prefix == null) {
            if (ns == null) {
                writer.writeStartElement(localName);
            } else {
                prefix = "";
                writer.setDefaultNamespace(ns);
                writer.writeStartElement(ns, localName);
                curUri = writer.getNamespaceContext().getNamespaceURI(prefix);
                if (curUri == null || curUri.length() != ns.length()) {
                    writer.writeDefaultNamespace(ns);
                }
            }
        } else {
            writer.writeStartElement(prefix, localName, ns);
            curUri = writer.getNamespaceContext().getNamespaceURI(prefix);
            if (curUri == null || curUri.length() != ns.length() || !curUri.equals(ns)) {
                writer.writeNamespace(prefix, ns);
            }
        }
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String attrPrefix = writer.getNamespaceContext().getPrefix(attr.getNamespaceURI());
            if (attrPrefix == null) {
                writer.writeAttribute(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                continue;
            }
            writer.writeAttribute(attrPrefix, attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
        }
        String value = DOMUtils.getContent(e);
        if (value != null && value.length() > 0) {
            writer.writeCharacters(value);
        }
        NodeList nodes = e.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            STAXUtils.writeElement((Element)n, writer);
        }
        writer.writeEndElement();
    }

    private static Element getNamespaceDeclarer(Element e) {
        Node n;
        do {
            if (!(n = e.getParentNode()).equals(e)) continue;
            return null;
        } while (n.getNamespaceURI() == null);
        return (Element)n;
    }

    public static Document read(DocumentBuilder builder, XMLStreamReader reader) throws XMLStreamException {
        Element rootEl = null;
        Document doc = builder.newDocument();
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    rootEl = doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
                    doc.appendChild(rootEl);
                    STAXUtils.declareNamespaces(reader, rootEl);
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i));
                        attr.setValue(reader.getAttributeValue(i));
                        rootEl.setAttributeNode(attr);
                    }
                    reader.next();
                    STAXUtils.readElements(rootEl, reader);
                    reader.next();
                    return doc;
                }
                case 2: {
                    return doc;
                }
                case 4: {
                    if (rootEl == null) break;
                    rootEl.appendChild(doc.createTextNode(reader.getText()));
                    break;
                }
            }
            event = reader.next();
        }
        return doc;
    }

    public static void readElements(Element parent, XMLStreamReader reader) throws XMLStreamException {
        Element e = null;
        Document doc = parent.getOwnerDocument();
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    e = doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
                    STAXUtils.declareNamespaces(reader, e);
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i));
                        attr.setValue(reader.getAttributeValue(i));
                        e.setAttributeNode(attr);
                    }
                    parent.appendChild(e);
                    reader.next();
                    STAXUtils.readElements(e, reader);
                    reader.next();
                    break;
                }
                case 2: {
                    return;
                }
                case 4: {
                    parent.appendChild(doc.createTextNode(reader.getText()));
                    break;
                }
            }
            event = reader.next();
        }
    }

    private static void declareNamespaces(XMLStreamReader reader, Element node) {
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            String uri = reader.getNamespaceURI(i);
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null || uri.equals(node.getNamespaceURI())) continue;
            node.setAttribute("xmlns:" + prefix, uri);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(out, encoding);
            return writer;
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return factory.createXMLStreamReader(in, encoding);
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            return factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }
}

