/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.soap.SoapVersion;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.yom.Document;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;
import org.codehaus.yom.stax.StaxBuilder;

public class XMLServiceBuilder {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$util$XMLServiceBuilder == null ? (class$org$codehaus$xfire$util$XMLServiceBuilder = XMLServiceBuilder.class$("org.codehaus.xfire.util.XMLServiceBuilder")) : class$org$codehaus$xfire$util$XMLServiceBuilder));
    private XFire xfire;
    static /* synthetic */ Class class$org$codehaus$xfire$util$XMLServiceBuilder;
    static /* synthetic */ Class class$org$codehaus$xfire$transport$TransportManager;
    static /* synthetic */ Class class$org$codehaus$xfire$service$binding$BindingProvider;

    public XMLServiceBuilder(XFire xfire) {
        this.xfire = xfire;
    }

    protected XFire getXFire() {
        return this.xfire;
    }

    public Collection buildServices(InputStream stream) throws Exception {
        try {
            XMLInputFactory ifactory = XMLInputFactory.newInstance();
            XMLStreamReader reader = ifactory.createXMLStreamReader(stream);
            StaxBuilder builder = new StaxBuilder();
            Document doc = builder.build(reader);
            Element root = doc.getRootElement();
            ArrayList<Service> serviceList = new ArrayList<Service>();
            Elements contents = root.getChildElements();
            for (int i = 0; i < contents.size(); ++i) {
                Element element = contents.get(i);
                Elements services = element.getChildElements();
                for (int n = 0; n < services.size(); ++n) {
                    Element service = services.get(n);
                    serviceList.add(this.loadService(service));
                }
            }
            return serviceList;
        }
        catch (XMLStreamException e1) {
            log.error((Object)"Could not parse META-INF/xfire/services.xml!", (Throwable)e1);
            throw e1;
        }
    }

    protected Service loadService(Element service) throws Exception {
        ServiceRegistry registry = this.getXFire().getServiceRegistry();
        String name = this.getElementValue(service, "name", null);
        String namespace = this.getElementValue(service, "namespace", null);
        String style = this.getElementValue(service, "style", "");
        String use = this.getElementValue(service, "use", "");
        String serviceClass = this.getElementValue(service, "serviceClass", "");
        String implClassName = this.getElementValue(service, "implementationClass", "");
        String bindingProviderName = this.getElementValue(service, "bindingProvider", "");
        String soapVersionValue = this.getElementValue(service, "soapVersion", "1.1");
        SoapVersion soapVersion = soapVersionValue.equals("1.2") ? Soap12.getInstance() : Soap11.getInstance();
        Class clazz = null;
        try {
            clazz = this.loadClass(serviceClass);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Could not load service class: " + serviceClass, e);
        }
        BindingProvider bindingProvider = this.loadBindingProvider(bindingProviderName);
        String serviceFactory = this.getElementValue(service, "serviceFactory", "");
        ObjectServiceFactory factory = serviceFactory.equals("jsr181") || serviceFactory.equals("commons-attributes") ? this.getAnnotationServiceFactory(serviceFactory, bindingProvider) : this.loadServiceFactory(bindingProvider, serviceFactory);
        if (style.length() > 0) {
            factory.setStyle(style);
        }
        if (use.length() > 0) {
            factory.setUse(use);
        }
        factory.setSoapVersion(soapVersion);
        Service svc = null;
        svc = name != null || namespace != null ? factory.create(clazz, name, namespace, null) : factory.create(clazz);
        if (implClassName.length() > 0) {
            Class implClazz = null;
            try {
                implClazz = this.loadClass(implClassName);
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not load implementation class: " + serviceClass, e);
            }
            svc.setProperty("xfire.serviceImplClass", implClazz);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created Service " + name + " with impl " + implClazz + ", soap version: " + soapVersionValue + ", style: " + style + ", use: " + use + ", namespace " + svc.getServiceInfo().getName().getNamespaceURI()));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Created Service " + name + " with impl " + clazz + ", soap version: " + soapVersionValue + ", style: " + style + ", use: " + use + ", namespace " + svc.getServiceInfo().getName().getNamespaceURI()));
        }
        if (svc.getInHandlers() == null) {
            svc.setInHandlers(new ArrayList());
        }
        if (svc.getOutHandlers() == null) {
            svc.setOutHandlers(new ArrayList());
        }
        if (svc.getFaultHandlers() == null) {
            svc.setFaultHandlers(new ArrayList());
        }
        svc.getInHandlers().addAll(this.createHandlerPipeline(service.getFirstChildElement("inHandlers")));
        svc.getOutHandlers().addAll(this.createHandlerPipeline(service.getFirstChildElement("outHandlers")));
        svc.getFaultHandlers().addAll(this.createHandlerPipeline(service.getFirstChildElement("faultHandlers")));
        registry.register(svc);
        return svc;
    }

    protected ObjectServiceFactory loadServiceFactory(BindingProvider bindingProvider, String serviceFactoryName) {
        ObjectServiceFactory factory = null;
        if (serviceFactoryName.length() > 0) {
            try {
                Class clz = this.loadClass(serviceFactoryName);
                TransportManager tman = this.getXFire().getTransportManager();
                Constructor con = null;
                Object[] arguments = null;
                try {
                    con = clz.getConstructor(class$org$codehaus$xfire$transport$TransportManager == null ? (class$org$codehaus$xfire$transport$TransportManager = XMLServiceBuilder.class$("org.codehaus.xfire.transport.TransportManager")) : class$org$codehaus$xfire$transport$TransportManager, class$org$codehaus$xfire$service$binding$BindingProvider == null ? (class$org$codehaus$xfire$service$binding$BindingProvider = XMLServiceBuilder.class$("org.codehaus.xfire.service.binding.BindingProvider")) : class$org$codehaus$xfire$service$binding$BindingProvider);
                    arguments = new Object[]{tman, bindingProvider};
                }
                catch (NoSuchMethodException e) {
                    try {
                        con = clz.getConstructor(class$org$codehaus$xfire$transport$TransportManager == null ? (class$org$codehaus$xfire$transport$TransportManager = XMLServiceBuilder.class$("org.codehaus.xfire.transport.TransportManager")) : class$org$codehaus$xfire$transport$TransportManager);
                        arguments = new Object[]{tman};
                    }
                    catch (NoSuchMethodException e1) {
                        con = clz.getConstructor(new Class[0]);
                        arguments = new Object[]{};
                    }
                }
                return (ObjectServiceFactory)con.newInstance(arguments);
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not load service factory: " + serviceFactoryName, e);
            }
        }
        factory = new ObjectServiceFactory(this.getXFire().getTransportManager(), bindingProvider);
        return factory;
    }

    protected ObjectServiceFactory getAnnotationServiceFactory(String annotationType, BindingProvider bindingProvider) throws Exception {
        Class annotsClz = null;
        Class clz = this.loadClass("org.codehaus.xfire.annotations.AnnotationServiceFactory");
        if (annotationType.equals("jsr181")) {
            annotsClz = this.loadClass("org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations");
        } else if (annotationType.equals("commons-attributes")) {
            annotsClz = this.loadClass("org.codehaus.xfire.annotations.commons.CommonsWebAttributes");
        }
        Class webAnnot = this.loadClass("org.codehaus.xfire.annotations.WebAnnotations");
        Constructor con = clz.getConstructor(webAnnot, class$org$codehaus$xfire$transport$TransportManager == null ? (class$org$codehaus$xfire$transport$TransportManager = XMLServiceBuilder.class$("org.codehaus.xfire.transport.TransportManager")) : class$org$codehaus$xfire$transport$TransportManager, class$org$codehaus$xfire$service$binding$BindingProvider == null ? (class$org$codehaus$xfire$service$binding$BindingProvider = XMLServiceBuilder.class$("org.codehaus.xfire.service.binding.BindingProvider")) : class$org$codehaus$xfire$service$binding$BindingProvider);
        return (ObjectServiceFactory)con.newInstance(annotsClz.newInstance(), this.getXFire().getTransportManager(), bindingProvider);
    }

    protected BindingProvider loadBindingProvider(String bindingProviderName) {
        BindingProvider bindingProvider = null;
        if (bindingProviderName.length() > 0) {
            try {
                bindingProvider = (BindingProvider)this.loadClass(bindingProviderName).newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not load binding provider: " + bindingProvider, e);
            }
        }
        return bindingProvider;
    }

    private List createHandlerPipeline(Element child) throws Exception {
        if (child == null) {
            return Collections.EMPTY_LIST;
        }
        Elements handlers = child.getChildElements("handler");
        if (handlers.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Handler> pipe = new ArrayList<Handler>();
        for (int i = 0; i < handlers.size(); ++i) {
            pipe.add(this.getHandler(handlers.get(i).getValue()));
        }
        return pipe;
    }

    protected Handler getHandler(String name) throws Exception {
        return (Handler)this.loadClass(name).newInstance();
    }

    public String getElementValue(Element root, String name, String def) {
        String value;
        Element child = root.getFirstChildElement(name);
        if (child != null && (value = child.getValue()) != null && value.length() > 0) {
            return value;
        }
        return def;
    }

    protected Class loadClass(String className) throws Exception {
        if (className.endsWith("[]")) {
            className = "[L" + className.substring(0, className.length() - 2) + ";";
        }
        return ClassLoaderUtils.loadClass(className, this.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

