/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.MessageHeaderInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.WSDL11Transport;
import org.codehaus.xfire.wsdl11.builder.AbstractWSDL;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Node;

public class WSDLBuilder
extends AbstractWSDL
implements WSDLWriter {
    private PortType portType;
    private Binding binding;
    private TransportManager transportManager;
    private Map wsdlOps = new HashMap();
    private WSDL11ParameterBinding paramBinding;
    private List declaredParameters = new ArrayList();

    public WSDLBuilder(Service service, TransportManager transportManager, WSDL11ParameterBinding paramBinding) throws WSDLException {
        super(service);
        this.transportManager = transportManager;
        this.paramBinding = paramBinding;
    }

    public void write(OutputStream out) throws IOException {
        try {
            PortType portType = this.createAbstractInterface();
            this.createConcreteInterface(portType);
            this.writeDocument();
        }
        catch (WSDLException e) {
            throw new XFireRuntimeException("error creating wsdl", e);
        }
        super.write(out);
    }

    public PortType createAbstractInterface() throws WSDLException {
        Service service = this.getService();
        Definition def = this.getDefinition();
        QName portName = new QName(this.getInfo().getTargetNamespace(), this.getInfo().getPortType());
        this.portType = def.createPortType();
        this.portType.setQName(portName);
        this.portType.setUndefined(false);
        def.addPortType(this.portType);
        Iterator itr = service.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo op = (OperationInfo)itr.next();
            Message req = this.createInputMessage(op);
            def.addMessage(req);
            Message res = null;
            if (op.getMEP().equals("urn:xfire:mep:in-out")) {
                res = this.createOutputMessage(op);
                def.addMessage(res);
            }
            Operation wsdlOp = this.createOperation(op, req, res);
            wsdlOp.setUndefined(false);
            this.portType.addOperation(wsdlOp);
            this.wsdlOps.put(op.getName(), wsdlOp);
        }
        return this.portType;
    }

    public void createConcreteInterface(PortType portType) {
        Service service = this.getService();
        Definition def = this.getDefinition();
        QName name = new QName(this.getInfo().getTargetNamespace(), this.getInfo().getServiceName());
        javax.wsdl.Service wsdlService = def.createService();
        wsdlService.setQName(name);
        Iterator itr = this.transportManager.getTransports(service.getName()).iterator();
        while (itr.hasNext()) {
            Transport transportObj = (Transport)itr.next();
            if (!(transportObj instanceof WSDL11Transport)) continue;
            WSDL11Transport transport = (WSDL11Transport)((Object)transportObj);
            Binding transportBinding = transport.createBinding(this, portType, this.paramBinding);
            Iterator oitr = service.getServiceInfo().getOperations().iterator();
            while (oitr.hasNext()) {
                OperationInfo op = (OperationInfo)oitr.next();
                Operation wsdlOp = (Operation)this.wsdlOps.get(op.getName());
                BindingOperation bop = transport.createBindingOperation(this, portType, wsdlOp, this.paramBinding);
                transportBinding.addBindingOperation(bop);
                this.createHeaders(op, bop);
            }
            Port transportPort = transport.createPort(this, transportBinding);
            def.addBinding(transportBinding);
            wsdlService.addPort(transportPort);
        }
        def.addService(wsdlService);
    }

    private void createHeaders(OperationInfo op, BindingOperation bop) {
        List inputHeaders = op.getInputMessage().getMessageHeaders();
        if (inputHeaders.size() == 0) {
            return;
        }
        BindingInput bindingInput = bop.getBindingInput();
        Message reqHeaders = this.createHeaderMessages(op.getInputMessage());
        this.getDefinition().addMessage(reqHeaders);
        Iterator headerItr = reqHeaders.getParts().values().iterator();
        while (headerItr.hasNext()) {
            Part headerInfo = (Part)headerItr.next();
            SOAPHeaderImpl soapHeader = new SOAPHeaderImpl();
            soapHeader.setMessage(reqHeaders.getQName());
            soapHeader.setPart(headerInfo.getName());
            soapHeader.setUse(this.paramBinding.getUse());
            bindingInput.addExtensibilityElement((ExtensibilityElement)soapHeader);
        }
    }

    private Message createOutputMessage(OperationInfo op) {
        Message res = this.getDefinition().createMessage();
        res.setQName(new QName(this.getInfo().getTargetNamespace(), op.getName() + "Response"));
        res.setUndefined(false);
        this.paramBinding.createOutputParts(this, res, op);
        return res;
    }

    private Message createInputMessage(OperationInfo op) {
        Message req = this.getDefinition().createMessage();
        req.setQName(new QName(this.getInfo().getTargetNamespace(), op.getName() + "Request"));
        req.setUndefined(false);
        this.paramBinding.createInputParts(this, req, op);
        return req;
    }

    private Message createHeaderMessages(MessageInfo msgInfo) {
        Message msg = this.getDefinition().createMessage();
        msg.setQName(new QName(this.getInfo().getTargetNamespace(), msgInfo.getName().getLocalPart() + "Headers"));
        msg.setUndefined(false);
        Iterator itr = msgInfo.getMessageHeaders().iterator();
        while (itr.hasNext()) {
            MessageHeaderInfo header = (MessageHeaderInfo)itr.next();
            Part part = this.createPart(header);
            msg.addPart(part);
        }
        return msg;
    }

    public Part createPart(MessageHeaderInfo header) {
        return this.createPart(header.getName(), header.getTypeClass(), header.getSchemaType());
    }

    public Part createPart(MessagePartInfo part) {
        return this.createPart(part.getName(), part.getTypeClass(), part.getSchemaType());
    }

    public Part createPart(QName pName, Class clazz, SchemaType type) {
        this.addDependency(type);
        QName schemaTypeName = type.getSchemaType();
        Part part = this.getDefinition().createPart();
        part.setName(pName.getLocalPart());
        if (!type.isAbstract()) {
            String prefix = this.getNamespacePrefix(schemaTypeName.getNamespaceURI());
            this.addNamespace(prefix, schemaTypeName.getNamespaceURI());
            part.setElementName(schemaTypeName);
            return part;
        }
        if (!this.declaredParameters.contains(pName)) {
            Element schemaEl = this.createSchemaType(this.getInfo().getTargetNamespace());
            Element element = new Element("xsd:element", "http://www.w3.org/2001/XMLSchema");
            schemaEl.appendChild((Node)element);
            String prefix = this.getNamespacePrefix(schemaTypeName.getNamespaceURI());
            this.addNamespace(prefix, schemaTypeName.getNamespaceURI());
            if (type.isAbstract()) {
                element.addAttribute(new Attribute("name", pName.getLocalPart()));
                element.addAttribute(new Attribute("type", prefix + ":" + schemaTypeName.getLocalPart()));
            }
            this.declaredParameters.add(pName);
        }
        part.setElementName(pName);
        return part;
    }

    public Operation createOperation(OperationInfo op, Message req, Message res) {
        Definition def = this.getDefinition();
        Operation wsdlOp = def.createOperation();
        Input input = def.createInput();
        input.setMessage(req);
        input.setName(req.getQName().getLocalPart());
        wsdlOp.setInput(input);
        if (res != null) {
            Output output = def.createOutput();
            output.setMessage(res);
            output.setName(res.getQName().getLocalPart());
            wsdlOp.setOutput(output);
        }
        wsdlOp.setName(op.getName());
        return wsdlOp;
    }
}

