/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmlbeans;

import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.yom.stax.StaxBuilder;

public class XmlBeansFault
extends XFireFault {
    private static final long serialVersionUID = 1L;
    private XmlObject fault;

    public XmlBeansFault(XmlObject fault) {
        this.fault = fault;
        XmlCursor cursor = fault.newCursor();
        cursor.toFirstChild();
        if (cursor.getName().getNamespaceURI().equals(Soap11.getInstance().getNamespace())) {
            this.createSoap11Fault(cursor);
        } else {
            this.createSoap12Fault(cursor);
        }
    }

    protected void createSoap11Fault(XmlCursor cursor) {
        cursor.toFirstChild();
        do {
            if (cursor.getName().getLocalPart().equals("faultcode")) {
                this.setFaultCode(cursor.getTextValue());
            }
            if (cursor.getName().getLocalPart().equals("faultstring")) {
                this.setMessage(cursor.getTextValue());
            }
            if (cursor.getName().getLocalPart().equals("faultactor")) {
                this.setRole(cursor.getTextValue());
            }
            if (!cursor.getName().getLocalPart().equals("detail")) continue;
            StaxBuilder builder = new StaxBuilder();
            try {
                this.setDetail(builder.buildElement(null, cursor.newXMLStreamReader()));
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        } while (cursor.toNextSibling());
    }

    protected void createSoap12Fault(XmlCursor cursor) {
    }

    public XmlObject getFault() {
        return this.fault;
    }

    public void setFault(XmlObject fault) {
        this.fault = fault;
    }
}

