/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmlbeans;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.WSDL11ParameterBinding;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;
import org.codehaus.xfire.xmlbeans.XmlBeansType;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Document;
import org.codehaus.yom.Element;
import org.codehaus.yom.stax.StaxBuilder;
import org.codehaus.yom.xpath.YOMXPath;
import org.jaxen.JaxenException;

public class XmlBeansWSDLBuilder
extends WSDLBuilder {
    private static final StaxBuilder builder = new StaxBuilder();
    private static Map schemas = new HashMap();

    public XmlBeansWSDLBuilder(Service service, TransportManager tman, WSDL11ParameterBinding paramBinding) throws WSDLException {
        super(service, tman, paramBinding);
    }

    public void addDependency(SchemaType type) {
        XmlBeansType xbeanType;
        String ns;
        if (!this.hasDependency(type) && type instanceof XmlBeansType && !this.hasSchema(ns = (xbeanType = (XmlBeansType)type).getSchemaType().getNamespaceURI())) {
            Element schema = this.getSchema(xbeanType);
            schema.detach();
            this.setSchema(ns, schema);
        }
        super.addDependency(type);
    }

    public Element getSchema(XmlBeansType xbeanType) {
        org.apache.xmlbeans.SchemaType type = XmlBeans.typeForClass((Class)xbeanType.getTypeClass());
        String name = type.getSourceName();
        if (name == null) {
            return null;
        }
        Element schema = (Element)schemas.get(name);
        if (schema != null) {
            return schema;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            XmlObject obj = XmlObject.Factory.parse((InputStream)classLoader.getResourceAsStream("schemaorg_apache_xmlbeans/src/" + name));
            schema = builder.buildElement(null, obj.newXMLStreamReader());
            Document schemaDoc = new Document(schema);
            schemas.put(name, schema);
            String ns = xbeanType.getSchemaType().getNamespaceURI();
            String expr = "//xsd:schema[@targetNamespace='" + ns + "']";
            List nodes = this.getMatches(schema, expr);
            if (nodes.size() == 0) {
                return null;
            }
            Element node = (Element)nodes.get(0);
            nodes = this.getMatches(schema, "//xsd:import");
            for (int i = 0; i < nodes.size(); ++i) {
                Element imp = (Element)nodes.get(i);
                Attribute schemaLoc = imp.getAttribute("schemaLocation");
                if (schemaLoc == null) continue;
                schemaLoc.detach();
            }
            return node;
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't load schema.", e);
        }
    }

    private List getMatches(Object doc, String xpath) {
        try {
            YOMXPath path = new YOMXPath(xpath);
            path.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            path.addNamespace("s", "http://www.w3.org/2001/XMLSchema");
            List result = path.selectNodes(doc);
            return result;
        }
        catch (JaxenException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }
}

