/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire;

import org.codehaus.xfire.AbstractContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.AbstractMessageExchange;
import org.codehaus.xfire.exchange.InExchange;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.exchange.RobustInOutExchange;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Session;

public class MessageContext
extends AbstractContext {
    private Session session;
    private Service service;
    private Binding binding;
    private MessageExchange exchange;
    private HandlerPipeline inPipeline;
    private HandlerPipeline outPipeline;
    private XFire xfire;

    public XFire getXFire() {
        return this.xfire;
    }

    public void setXFire(XFire xfire) {
        this.xfire = xfire;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public MessageExchange createMessageExchange(OperationInfo operation) {
        MessageExchange ex = this.createMessageExchange(operation.getMEP());
        ex.setOperation(operation);
        return ex;
    }

    public MessageExchange createMessageExchange(String mepUri) {
        AbstractMessageExchange ex = null;
        if (mepUri.equals("urn:xfire:mep:in-out")) {
            ex = new RobustInOutExchange(this);
        } else if (mepUri.equals("urn:xfire:mep:in")) {
            ex = new InExchange(this);
        }
        this.setExchange(ex);
        return ex;
    }

    public MessageExchange getExchange() {
        return this.exchange;
    }

    public void setExchange(MessageExchange exchange) {
        this.exchange = exchange;
    }

    public OutMessage getOutMessage() {
        return this.exchange.getOutMessage();
    }

    public InMessage getInMessage() {
        return this.exchange.getInMessage();
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public HandlerPipeline getInPipeline() {
        return this.inPipeline;
    }

    public void setInPipeline(HandlerPipeline messagePipeline) {
        this.inPipeline = messagePipeline;
    }

    public HandlerPipeline getOutPipeline() {
        return this.outPipeline;
    }

    public void setOutPipeline(HandlerPipeline outPipeline) {
        this.outPipeline = outPipeline;
    }
}

