/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.stax.ElementReader;
import org.codehaus.xfire.aegis.stax.ElementWriter;
import org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.aegis.type.basic.ObjectType;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.wsdl.SchemaType;

public class AegisBindingProvider
implements BindingProvider {
    public static final String TYPE_MAPPING_KEY = "type.mapping";
    public static final String ENCODING_URI_KEY = "type.encodingUri";
    private static final int IN_PARAM = 0;
    private static final int OUT_PARAM = 1;
    private static final int FAULT_PARAM = 2;
    private TypeMappingRegistry registry;
    private Map part2type = new HashMap();

    public AegisBindingProvider() {
        this(new DefaultTypeMappingRegistry(true));
    }

    public AegisBindingProvider(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.registry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry registry) {
        this.registry = registry;
    }

    public void initialize(Service endpoint) {
        Iterator itr = endpoint.getServiceInfo().getOperations().iterator();
        while (itr.hasNext()) {
            OperationInfo opInfo = (OperationInfo)itr.next();
            try {
                this.initializeMessage(endpoint, opInfo.getInputMessage(), 0);
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing parameters for method " + opInfo.getMethod());
                throw e;
            }
            try {
                if (opInfo.hasOutput()) {
                    this.initializeMessage(endpoint, opInfo.getOutputMessage(), 1);
                }
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing return value for method " + opInfo.getMethod());
                throw e;
            }
            try {
                Iterator faultItr = opInfo.getFaults().iterator();
                while (faultItr.hasNext()) {
                    FaultInfo info = (FaultInfo)faultItr.next();
                    this.initializeMessage(endpoint, info, 2);
                }
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing fault for method " + opInfo.getMethod());
                throw e;
            }
            try {
                Iterator bItr = endpoint.getBindings().iterator();
                while (bItr.hasNext()) {
                    Binding binding = (Binding)bItr.next();
                    this.initializeMessage(endpoint, binding.getHeaders(opInfo.getInputMessage()), 0);
                    if (!opInfo.hasOutput()) continue;
                    this.initializeMessage(endpoint, binding.getHeaders(opInfo.getOutputMessage()), 1);
                }
            }
            catch (XFireRuntimeException e) {
                e.prepend("Error initializing fault for method " + opInfo.getMethod());
                throw e;
            }
        }
    }

    protected void initializeMessage(Service service, MessagePartContainer container, int type) {
        Iterator itr = container.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            if (part.getSchemaType() != null) continue;
            part.setSchemaType(this.getParameterType(this.getTypeMapping(service), part, type));
        }
    }

    public Object readParameter(MessagePartInfo p, XMLStreamReader xsr, MessageContext context) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        ElementReader reader = new ElementReader(xsr);
        return type.readObject(reader, context);
    }

    public void writeParameter(MessagePartInfo p, XMLStreamWriter writer, MessageContext context, Object value) throws XFireFault {
        Type type = (Type)p.getSchemaType();
        boolean writeOuter = type.isWriteOuter();
        ElementWriter mw = writeOuter ? new ElementWriter(writer, p.getName()) : new ElementWriter(writer);
        type.writeObject(value, mw, context);
        if (writeOuter) {
            mw.close();
        }
    }

    public QName getSuggestedName(Service service, OperationInfo op, int param) {
        TypeMapping tm = this.getTypeMapping(service);
        Type type = tm.getTypeCreator().createType(op.getMethod(), param);
        if (type.isComplex() && !type.isAbstract()) {
            return type.getSchemaType();
        }
        return null;
    }

    private Type getParameterType(TypeMapping tm, MessagePartInfo param, int paramtype) {
        Type type = tm.getType(param.getName());
        if (type == null) {
            type = (Type)this.part2type.get(param);
        }
        if (type == null) {
            OperationInfo op = param.getContainer().getOperation();
            type = paramtype != 2 ? tm.getTypeCreator().createType(op.getMethod(), param.getIndex()) : tm.getTypeCreator().createType(param.getTypeClass());
            type.setTypeMapping(tm);
            this.part2type.put(param, type);
        }
        return type;
    }

    public TypeMapping getTypeMapping(Service service) {
        TypeMapping tm = (TypeMapping)service.getProperty(TYPE_MAPPING_KEY);
        if (tm == null) {
            tm = this.createTypeMapping(service);
        }
        return tm;
    }

    protected TypeMapping createTypeMapping(Service endpoint) {
        String encodingStyle = (String)endpoint.getProperty(ENCODING_URI_KEY);
        if (encodingStyle == null) {
            encodingStyle = "http://www.w3.org/2001/XMLSchema";
        }
        endpoint.setProperty(ENCODING_URI_KEY, encodingStyle);
        TypeMapping tm = this.registry.createTypeMapping(encodingStyle, true);
        endpoint.setProperty(TYPE_MAPPING_KEY, tm);
        this.registry.register(endpoint.getName().getNamespaceURI(), tm);
        return tm;
    }

    public Class getTypeClass(QName name, Service service) {
        TypeMapping tm = this.getTypeMapping(service);
        Type type = tm.getType(name);
        if (type == null) {
            return null;
        }
        return tm.getType(name).getTypeClass();
    }

    public SchemaType getSchemaType(QName name, Service service) {
        TypeMapping tm = service != null ? this.getTypeMapping(service) : this.registry.getDefaultTypeMapping();
        Type type = tm.getType(name);
        if (type == null) {
            ObjectType ot = new ObjectType();
            ot.setSchemaType(name);
            type = ot;
        }
        return type;
    }

    public Type getType(Service service, Class clazz) {
        TypeMapping tm = this.getTypeMapping(service);
        Type type = tm.getType(clazz);
        if (type == null) {
            type = tm.getTypeCreator().createType(clazz);
            tm.register(type);
        }
        return type;
    }
}

