/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.java5;

import java.beans.PropertyDescriptor;
import javax.xml.namespace.QName;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.basic.BeanTypeInfo;
import org.codehaus.xfire.aegis.type.java5.IgnoreProperty;
import org.codehaus.xfire.aegis.type.java5.XmlAttribute;
import org.codehaus.xfire.aegis.type.java5.XmlElement;
import org.codehaus.xfire.aegis.type.java5.XmlType;
import org.codehaus.xfire.util.NamespaceHelper;

public class AnnotatedTypeInfo
extends BeanTypeInfo {
    public AnnotatedTypeInfo(TypeMapping tm, Class typeClass, String ns) {
        super(typeClass, ns);
        this.setTypeMapping(tm);
        this.initialize();
    }

    protected void mapProperty(PropertyDescriptor pd) {
        if (this.isIgnored(pd)) {
            return;
        }
        String name = pd.getName();
        if (this.isAttribute(pd)) {
            this.mapAttribute(name, this.createMappedName(pd));
        } else if (this.isElement(pd)) {
            this.mapElement(name, this.createMappedName(pd));
        }
    }

    protected boolean registerType(PropertyDescriptor desc) {
        XmlAttribute att = desc.getReadMethod().getAnnotation(XmlAttribute.class);
        if (att != null && att.type() != Type.class) {
            return false;
        }
        XmlElement el = desc.getReadMethod().getAnnotation(XmlElement.class);
        if (el != null && el.type() != Type.class) {
            return false;
        }
        return super.registerType(desc);
    }

    protected boolean isIgnored(PropertyDescriptor desc) {
        return desc.getReadMethod().isAnnotationPresent(IgnoreProperty.class);
    }

    protected boolean isAttribute(PropertyDescriptor desc) {
        return desc.getReadMethod().isAnnotationPresent(XmlAttribute.class);
    }

    protected boolean isElement(PropertyDescriptor desc) {
        return !this.isAttribute(desc);
    }

    protected boolean isAnnotatedElement(PropertyDescriptor desc) {
        return desc.getReadMethod().isAnnotationPresent(XmlElement.class);
    }

    protected QName createMappedName(PropertyDescriptor desc) {
        return this.createQName(desc);
    }

    protected QName createQName(PropertyDescriptor desc) {
        String name = null;
        String ns = null;
        XmlType xtype = this.getTypeClass().getAnnotation(XmlType.class);
        if (xtype != null) {
            ns = xtype.namespace();
        }
        if (this.isAttribute(desc)) {
            XmlAttribute att = desc.getReadMethod().getAnnotation(XmlAttribute.class);
            name = att.name();
            if (att.namespace().length() > 0) {
                ns = att.namespace();
            }
        } else if (this.isAnnotatedElement(desc)) {
            XmlElement att = desc.getReadMethod().getAnnotation(XmlElement.class);
            name = att.name();
            if (att.namespace().length() > 0) {
                ns = att.namespace();
            }
        }
        if (name == null || name.length() == 0) {
            name = desc.getName();
        }
        if (ns == null || ns.length() == 0) {
            ns = NamespaceHelper.makeNamespaceFromClassName(this.getTypeClass().getName(), "http");
        }
        return new QName(ns, name);
    }

    public boolean isNillable(QName name) {
        PropertyDescriptor desc = this.getPropertyDescriptorFromMappedName(name);
        if (this.isAnnotatedElement(desc)) {
            XmlElement att = desc.getReadMethod().getAnnotation(XmlElement.class);
            return att.nillable();
        }
        return super.isNillable(name);
    }
}

