/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.exchange.RobustInOutExchange;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.soap.SoapBinding;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.stax.JDOMStreamReader;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;
import org.jdom.Element;
import org.xml.sax.InputSource;

public class Client
extends AbstractHandlerSupport
implements ChannelEndpoint {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$client$Client == null ? (class$org$codehaus$xfire$client$Client = Client.class$("org.codehaus.xfire.client.Client")) : class$org$codehaus$xfire$client$Client));
    public static final String CLIENT_MODE = "client.mode";
    private Object[] response;
    private Transport transport;
    private Service service;
    private Binding binding;
    private String url;
    private int timeout = 10000;
    private MessageContext context;
    private Exception fault;
    private String endpointUri;
    private XFire xfire = XFireFactory.newInstance().getXFire();
    static /* synthetic */ Class class$org$codehaus$xfire$client$Client;

    protected Client() {
        this.addOutHandler(new OutMessageSender());
    }

    public Client(Endpoint endpoint) {
        this(endpoint.getBinding(), endpoint.getAddress());
    }

    public Client(Binding binding, String url) {
        this(binding.getTransport(), binding.getService(), url);
        this.binding = binding;
    }

    public Client(Transport transport, Service service, String url) {
        this(transport, service, url, null);
        this.findBinding(transport, service);
    }

    public Client(Transport transport, Service service, String url, String endpointUri) {
        this();
        this.transport = transport;
        this.url = url;
        this.endpointUri = endpointUri;
        this.setService(service);
        this.binding = this.findBinding(transport, service);
    }

    public Client(Definition definition, Class serviceClass) throws Exception {
        this();
        Transport transport = this.xfire.getTransportManager().getTransportForUri("http://schemas.xmlsoap.org/wsdl/soap/http");
        this.initFromDefinition(transport, definition, serviceClass);
    }

    public Client(Transport transport, Definition definition, Class serviceClass) throws Exception {
        this();
        this.initFromDefinition(transport, definition, serviceClass);
    }

    public Client(URL wsdlLocation) throws Exception {
        this(wsdlLocation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client(URL wsdlLocation, Class serviceClass) throws Exception {
        this();
        InputStream is = wsdlLocation.openStream();
        try {
            InputSource src = new InputSource(is);
            Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, src);
            Transport transport = this.xfire.getTransportManager().getTransport("http://schemas.xmlsoap.org/wsdl/soap/http");
            this.initFromDefinition(transport, def, serviceClass);
        }
        finally {
            is.close();
        }
    }

    private void setService(Service service) {
        this.service = service;
        this.service.setFaultSerializer(service.getFaultSerializer());
        this.service.setSoapVersion(service.getSoapVersion());
    }

    protected void initFromDefinition(Transport transport, Definition definition, Class serviceClass) throws Exception {
        WSDLServiceBuilder builder = new WSDLServiceBuilder(definition);
        builder.setTransportManager(this.xfire.getTransportManager());
        builder.walkTree();
        Endpoint ep = this.findEndpoint(transport, builder.getServices());
        this.url = ep.getAddress();
        this.binding = ep.getBinding();
        this.transport = ep.getBinding().getTransport();
        if (serviceClass != null) {
            ep.getBinding().getService().getServiceInfo().setServiceClass(serviceClass);
        }
        this.setService(ep.getBinding().getService());
    }

    public Endpoint findEndpoint(Transport transport, Collection services) {
        Iterator itr = services.iterator();
        while (itr.hasNext()) {
            Service service = (Service)itr.next();
            Iterator eitr = service.getEndpoints().iterator();
            while (eitr.hasNext()) {
                Endpoint ep = (Endpoint)eitr.next();
                if (ep.getBinding().getTransport() == null || !ep.getBinding().getTransport().equals(transport)) continue;
                return ep;
            }
        }
        return null;
    }

    private Binding findBinding(Transport transport, Service service) {
        Iterator itr = service.getBindings().iterator();
        while (itr.hasNext()) {
            Binding b = (Binding)itr.next();
            if (b.getTransport() == null || !b.getTransport().equals(transport)) continue;
            return b;
        }
        return this.findSoapBinding(service);
    }

    private SoapBinding findSoapBinding(Service service) {
        Iterator itr = service.getBindings().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof SoapBinding)) continue;
            return (SoapBinding)o;
        }
        return null;
    }

    public Object[] invoke(OperationInfo op, Object[] params) throws Exception {
        try {
            OutMessage msg = new OutMessage(this.url);
            msg.setBody(params);
            msg.setChannel(this.getOutChannel());
            this.context = new MessageContext();
            this.context.setService(this.service);
            this.context.setXFire(this.xfire);
            this.context.setBinding(this.binding);
            this.context.setProperty(CLIENT_MODE, Boolean.TRUE);
            RobustInOutExchange exchange = new RobustInOutExchange(this.context);
            exchange.setOperation(op);
            exchange.setOutMessage(msg);
            this.context.setExchange(exchange);
            HandlerPipeline outPipe = new HandlerPipeline(this.xfire.getOutPhases());
            outPipe.addHandlers(this.getOutHandlers());
            outPipe.addHandlers(this.transport.getOutHandlers());
            this.context.setOutPipeline(outPipe);
            outPipe.invoke(this.context);
        }
        catch (Exception e1) {
            throw XFireFault.createFault(e1);
        }
        if (this.response == null && this.fault == null) {
            for (int count = 0; this.response == null && this.fault == null && count < this.timeout; count += 50) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        if (this.fault != null) {
            Exception localFault = this.fault;
            this.fault = null;
            throw localFault;
        }
        Object[] localResponse = this.response;
        this.response = null;
        return localResponse;
    }

    public void onReceive(MessageContext recvContext, InMessage msg) {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received message to " + msg.getUri()));
            }
            if (this.context.getExchange() == null) {
                this.context.setExchange(new RobustInOutExchange(this.context));
            }
            RobustInOutExchange exchange = (RobustInOutExchange)this.context.getExchange();
            exchange.setInMessage(msg);
            try {
                HandlerPipeline inPipe = new HandlerPipeline(this.xfire.getInPhases());
                inPipe.addHandlers(this.getInHandlers());
                inPipe.addHandlers(this.transport.getInHandlers());
                recvContext.setInPipeline(inPipe);
                inPipe.invoke(this.context);
                this.finishReadingMessage(msg, this.context);
                this.response = ((List)msg.getBody()).toArray();
            }
            catch (Exception e1) {
                XFireFault fault = XFireFault.createFault(e1);
                recvContext.getInPipeline().handleFault(fault, this.context);
                this.fault = fault;
                Element detail = fault.getDetail();
                if (detail == null) break block4;
                this.processFaultDetail(detail);
            }
        }
    }

    protected void processFaultDetail(Element detail) {
        if (detail.getContentSize() > 0) {
            Element exDetail = (Element)detail.getContent().get(0);
            MessagePartInfo faultPart = this.getFaultPart(this.context.getExchange().getOperation(), exDetail);
            if (faultPart == null) {
                return;
            }
            try {
                BindingProvider provider = this.context.getService().getBindingProvider();
                JDOMStreamReader reader = new JDOMStreamReader(exDetail);
                reader.nextTag();
                this.fault = (Exception)provider.readParameter(faultPart, reader, this.context);
            }
            catch (XFireFault e) {
                this.fault = e;
            }
            catch (XMLStreamException e) {
                this.fault = e;
            }
        }
    }

    protected MessagePartInfo getFaultPart(OperationInfo operation, Element exDetail) {
        QName qname = new QName(exDetail.getNamespaceURI(), exDetail.getName());
        Iterator itr = operation.getFaults().iterator();
        while (itr.hasNext()) {
            FaultInfo faultInfo = (FaultInfo)itr.next();
            MessagePartInfo part = faultInfo.getMessagePart(qname);
            if (part == null) continue;
            return part;
        }
        return null;
    }

    public void finishReadingMessage(InMessage message, MessageContext context) throws XFireFault {
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            while (reader.hasNext()) {
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Couldn't parse message.", e, "Sender");
        }
    }

    public Channel getOutChannel() {
        Channel channel = null;
        try {
            String uri = this.getEndpointUri();
            channel = uri == null ? this.getTransport().createChannel() : this.getTransport().createChannel(uri);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't open channel.", e);
        }
        channel.setEndpoint(this);
        return channel;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void receive(Object response) {
        this.response = ((List)response).toArray();
    }

    public Service getService() {
        return this.service;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void receiveFault(XFireFault fault) {
        this.fault = fault;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public void setXFire(XFire xfire) {
        this.xfire = xfire;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

