/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.stax.DepthXMLStreamReader;

public class MessageBinding
extends AbstractBinding {
    public void readMessage(InMessage message, MessageContext context) throws XFireFault {
        Service service = context.getService();
        OperationInfo operation = context.getExchange().getOperation();
        if (context.getExchange().getOperation() == null) {
            operation = (OperationInfo)service.getServiceInfo().getOperations().iterator().next();
            this.setOperation(operation, context);
        }
        DepthXMLStreamReader dr = new DepthXMLStreamReader(message.getXMLStreamReader());
        STAXUtils.toNextElement(dr);
        ArrayList<Object> params = new ArrayList<Object>();
        Binding binding = context.getBinding();
        Iterator itr = operation.getInputMessage().getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo p = (MessagePartInfo)itr.next();
            params.add(service.getBindingProvider().readParameter(p, message.getXMLStreamReader(), context));
            this.nextEvent(message.getXMLStreamReader());
        }
        message.setBody(params);
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        Object[] values = (Object[])message.getBody();
        OperationInfo operation = context.getExchange().getOperation();
        int i = 0;
        Iterator itr = operation.getOutputMessage().getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo p = (MessagePartInfo)itr.next();
            context.getService().getBindingProvider().writeParameter(p, writer, context, values[i]);
            ++i;
        }
    }
}

