/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.remoting;

import java.lang.reflect.Modifier;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BeanInvoker;
import org.codehaus.xfire.spring.remoting.XFireServletControllerAdapter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class Jsr181HandlerMapping
extends AbstractUrlHandlerMapping {
    private WebAnnotations webAnnotations;
    private XFire xFire;
    private TypeMappingRegistry typeMappingRegistry;
    private String urlPrefix = "/services/";

    protected void initApplicationContext() throws BeansException {
        AnnotationServiceFactory serviceFactory = new AnnotationServiceFactory(this.webAnnotations, this.xFire.getTransportManager(), new AegisBindingProvider(this.typeMappingRegistry));
        for (ApplicationContext context = this.getApplicationContext(); context != null; context = context.getParent()) {
            this.processBeans(context, serviceFactory);
        }
    }

    private void processBeans(ApplicationContext beanFactory, AnnotationServiceFactory serviceFactory) {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            Object bean;
            Class clazz;
            try {
                clazz = this.getApplicationContext().getType(beanNames[i]);
                bean = beanFactory.getBean(beanNames[i]);
            }
            catch (BeanIsAbstractException e) {
                continue;
            }
            if (clazz != null && !Modifier.isAbstract(clazz.getModifiers()) && this.webAnnotations.hasWebServiceAnnotation(clazz)) {
                Service endpoint = serviceFactory.create(clazz);
                ServiceInfo service = endpoint.getServiceInfo();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Exposing SOAP v." + endpoint.getSoapVersion().getVersion() + " service " + endpoint.getName() + " to " + this.urlPrefix + endpoint.getSimpleName()));
                }
                this.xFire.getServiceRegistry().register(endpoint);
                endpoint.setInvoker(new BeanInvoker(bean));
                XFireServletControllerAdapter controller = new XFireServletControllerAdapter(this.xFire, endpoint.getName());
                this.registerHandler(this.urlPrefix + endpoint.getSimpleName(), controller);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Rejected bean '" + beanNames[i] + "' since it has no WebService annotation"));
        }
    }

    public void setWebAnnotations(WebAnnotations webAnnotations) {
        this.webAnnotations = webAnnotations;
    }

    public void setXfire(XFire xFire) {
        this.xFire = xFire;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }
}

