/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.transport.http.OutMessageRequestEntity;
import org.codehaus.xfire.util.STAXUtils;

public class CommonsHttpMessageSender
extends AbstractMessageSender {
    private static final ThreadLocal httpState = new ThreadLocal();
    private PostMethod postMethod;
    private HttpClient client;
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$http$CommonsHttpMessageSender == null ? (class$org$codehaus$xfire$transport$http$CommonsHttpMessageSender = CommonsHttpMessageSender.class$("org.codehaus.xfire.transport.http.CommonsHttpMessageSender")) : class$org$codehaus$xfire$transport$http$CommonsHttpMessageSender));
    static /* synthetic */ Class class$org$codehaus$xfire$transport$http$CommonsHttpMessageSender;

    public CommonsHttpMessageSender(OutMessage message, MessageContext context) {
        super(message, context);
    }

    public void open() throws IOException, XFireFault {
        this.client = new HttpClient();
        this.client.getParams().setParameter("http.useragent", (Object)" Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; XFire Client +http://xfire.codehaus.org)");
        this.client.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        this.client.getParams().setVersion(HttpVersion.HTTP_1_1);
        this.postMethod = new PostMethod(this.getUri());
        this.postMethod.setRequestHeader("Content-Type", "text/xml; charset=" + this.getEncoding());
        if (this.getSoapAction() != null) {
            this.postMethod.setRequestHeader("SOAPAction", this.getQuotedSoapAction());
        }
    }

    public void send() throws HttpException, IOException {
        boolean chunkingOn = Boolean.valueOf((String)this.getMessageContext().getProperty("urn:xfire:transport:http:chunking-enabled"));
        Object requestEntity = !chunkingOn ? this.getByteArrayRequestEntity() : new OutMessageRequestEntity(this.getMessage(), this.getMessageContext());
        this.getMethod().setRequestEntity(requestEntity);
        this.client.executeMethod(null, (HttpMethod)this.postMethod, this.getHttpState());
    }

    private HttpState getHttpState() {
        HttpState state = (HttpState)httpState.get();
        if (null == state) {
            state = new HttpState();
            httpState.set(state);
        }
        return state;
    }

    private RequestEntity getByteArrayRequestEntity() throws IOException {
        OutMessage message = this.getMessage();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(bos, message.getEncoding());
        try {
            message.getSerializer().writeMessage(message, writer, this.getMessageContext());
            writer.close();
            bos.close();
            return new ByteArrayRequestEntity(bos.toByteArray());
        }
        catch (XFireFault e) {
            log.error((Object)"Couldn't send message.", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (XMLStreamException e) {
            log.error((Object)"Couldn't send message.", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public InMessage getInMessage() throws IOException {
        InputStream in = this.postMethod.getResponseBodyAsStream();
        return new InMessage(STAXUtils.createXMLStreamReader(in, this.getEncoding()), this.getUri());
    }

    public PostMethod getMethod() {
        return this.postMethod;
    }

    public void close() throws XFireException {
        if (this.postMethod != null) {
            this.postMethod.releaseConnection();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

