/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util.stax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.xfire.util.DOMUtils;
import org.codehaus.xfire.util.stax.DOMStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class W3CDOMStreamReader
extends DOMStreamReader {
    private Node content;
    private List uris = new ArrayList();
    private List prefixes = new ArrayList();
    private Map attributes = new HashMap();

    private void processNamespaces(Element element) {
        this.uris.clear();
        this.prefixes.clear();
        NamedNodeMap nodes = element.getAttributes();
        ArrayList nodeToRemove = new ArrayList();
        String nsURI = element.getNamespaceURI();
        String ePrefix = element.getPrefix();
        if (ePrefix == null) {
            ePrefix = "";
        }
        if (nsURI != null) {
            this.uris.add(nsURI);
            this.prefixes.add(ePrefix);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String prefix = node.getPrefix();
            String localName = node.getLocalName();
            String value = node.getNodeValue();
            String name = node.getNodeName();
            String uri = node.getNamespaceURI();
            if (prefix == null && ("xmlns".equals(name) || "xmlns".equals(localName))) {
                prefix = "xmls";
                localName = "";
            }
            if (prefix == null || this.prefixes.contains(localName)) continue;
            this.uris.add(uri);
            this.prefixes.add(prefix);
        }
        for (int j = 0; j < nodeToRemove.size(); ++j) {
            Node rNode = (Node)nodeToRemove.get(j);
            if (rNode.getNamespaceURI() != null) {
                nodes.removeNamedItemNS(rNode.getNamespaceURI(), rNode.getLocalName());
                continue;
            }
            nodes.removeNamedItem(rNode.getNodeName());
        }
    }

    public W3CDOMStreamReader(Element element) {
        super(new DOMStreamReader.ElementFrame(element));
        this.processNamespaces(element);
    }

    protected void endElement() {
        super.endElement();
    }

    Element getCurrentElement() {
        return (Element)this.getCurrentFrame().element;
    }

    protected DOMStreamReader.ElementFrame getChildFrame(int currentChild) {
        return new DOMStreamReader.ElementFrame(this.getCurrentElement().getChildNodes().item(currentChild));
    }

    protected int getChildCount() {
        return this.getCurrentElement().getChildNodes().getLength();
    }

    protected int moveToChild(int currentChild) {
        this.content = this.getCurrentElement().getChildNodes().item(currentChild);
        if (this.content instanceof Text) {
            return 4;
        }
        if (this.content instanceof Element) {
            this.processNamespaces((Element)this.content);
            return 1;
        }
        if (this.content instanceof CDATASection) {
            return 4;
        }
        if (this.content instanceof Comment) {
            return 4;
        }
        if (this.content instanceof EntityReference) {
            return 9;
        }
        throw new IllegalStateException();
    }

    public String getElementText() throws XMLStreamException {
        return DOMUtils.getContent(this.content);
    }

    public String getNamespaceURI(String prefix) {
        int index = this.prefixes.indexOf(prefix);
        if (index == -1) {
            return null;
        }
        return (String)this.uris.get(index);
    }

    public String getAttributeValue(String ns, String local) {
        Attr at = ns == null || ns.equals("") ? this.getCurrentElement().getAttributeNode(local) : this.getCurrentElement().getAttributeNodeNS(ns, local);
        if (at == null) {
            return null;
        }
        return DOMUtils.getContent(at);
    }

    public int getAttributeCount() {
        return this.getCurrentElement().getAttributes().getLength();
    }

    Attr getAttribute(int i) {
        return (Attr)this.getCurrentElement().getAttributes().item(i);
    }

    private String getLocalName(Attr attr) {
        String name = attr.getLocalName();
        if (name == null) {
            name = attr.getNodeName();
        }
        return name;
    }

    public QName getAttributeName(int i) {
        Attr at = this.getAttribute(i);
        String prefix = at.getPrefix();
        String ln = this.getLocalName(at);
        String ns = at.getNamespaceURI();
        if (prefix == null) {
            return new QName(ns, ln);
        }
        return new QName(ns, ln, prefix);
    }

    public String getAttributeNamespace(int i) {
        return this.getAttribute(i).getNamespaceURI();
    }

    public String getAttributeLocalName(int i) {
        Attr attr = this.getAttribute(i);
        String name = this.getLocalName(attr);
        return name;
    }

    public String getAttributePrefix(int i) {
        return this.getAttribute(i).getPrefix();
    }

    public String getAttributeType(int i) {
        return W3CDOMStreamReader.toStaxType(this.getAttribute(i).getNodeType());
    }

    public static String toStaxType(short jdom) {
        switch (jdom) {
            default: 
        }
        return null;
    }

    public String getAttributeValue(int i) {
        return this.getAttribute(i).getValue();
    }

    public boolean isAttributeSpecified(int i) {
        return this.getAttribute(i).getValue() != null;
    }

    public int getNamespaceCount() {
        return this.uris.size();
    }

    public String getNamespacePrefix(int i) {
        return (String)this.prefixes.get(i);
    }

    public String getNamespaceURI(int i) {
        return (String)this.uris.get(i);
    }

    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return DOMUtils.getContent(this.getCurrentElement());
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public String getEncoding() {
        return null;
    }

    public QName getName() {
        Element el = this.getCurrentElement();
        String prefix = this.getPrefix();
        String ln = this.getLocalName();
        if (prefix == null) {
            return new QName(el.getNamespaceURI(), ln);
        }
        return new QName(el.getNamespaceURI(), ln, prefix);
    }

    public String getLocalName() {
        return this.getCurrentElement().getLocalName();
    }

    public String getNamespaceURI() {
        return this.getCurrentElement().getNamespaceURI();
    }

    public String getPrefix() {
        String prefix = this.getCurrentElement().getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }
}

