/*
 * Decompiled with CFR 0.152.
 */
package xin.alum.aio;

import com.google.protobuf.Message;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import org.springframework.stereotype.Component;
import xin.alum.aio.constant.AioPlatform;
import xin.alum.aio.groups.Sessions;
import xin.alum.aio.handler.AioReceiver;
import xin.alum.aio.model.Aio;
import xin.alum.aio.model.Events;
import xin.alum.aio.model.Transportable;

@Component
public class AioReciveService
extends AioReceiver {
    String groupKey = "test_group";

    public boolean onHandShake(Channel ch, FullHttpRequest req, FullHttpResponse res) {
        String tokens = (String)this.sessions.getAttr(ch, "token");
        res.setStatus(HttpResponseStatus.UNAUTHORIZED);
        return tokens != null;
    }

    public void onHandShaked(Channel ch) {
        String token = ch.attr(AttributeKey.valueOf((String)"token")).toString();
        this.sessions.bindUser(ch, token, AioPlatform.WINDOWS, "");
    }

    public void onRecive(Channel ch, Events s) {
        long l = System.currentTimeMillis();
        Sessions sessions = this.groups.get(this.groupKey);
        if (!sessions.contains((Object)ch)) {
            sessions = this.groups.bind(ch, this.groupKey);
        }
        Aio.Data d = (Aio.Data)s.unpack(Aio.Data.class);
        Events events = new Events(s.getKey());
        Aio.Data.Builder b = Aio.Data.newBuilder();
        b.putAllAttrs(d.getAttrsMap());
        events.setData((Message)b.build());
        this.groups.sends(this.groupKey, (Transportable)events);
    }
}

